<?php
/**
 * UTM Save
 *
 * Salva parâmetros UTM na sessão para uso em redirecionamentos e links.
 * A filtragem de UTMs obrigatórias é feita pelo Protetor WePink.
 */

// Iniciar sessão se ainda não iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Parâmetros para captura (wpclid NÃO é salvo por segurança)
$UTM_KEYS = [
    'utm_source',
    'utm_medium',
    'utm_campaign',
    'utm_content',
    'utm_term',
    'utm_id',
    'src',
    'sck',
    'fbclid',
    // 'wpclid' - NÃO salvar por segurança (token secreto)
];

// Garante array na sessão
if (!isset($_SESSION['utm'])) {
    $_SESSION['utm'] = [];
}

// Se veio UTM na URL, atualiza sessão
foreach ($UTM_KEYS as $key) {
    if (!empty($_GET[$key])) {
        $_SESSION['utm'][$key] = $_GET[$key];
    }
}

/**
 * Monta query string das UTMs que temos na sessão
 *
 * @param bool $withQuestionMark Se true, adiciona ? no início
 * @return string Query string das UTMs
 */
function utm_build_query($withQuestionMark = true)
{
    if (empty($_SESSION['utm']) || !is_array($_SESSION['utm'])) {
        return '';
    }
    $q = http_build_query($_SESSION['utm']);
    return $withQuestionMark ? ('?' . $q) : $q;
}

/**
 * Adiciona UTMs numa URL que já pode ter parâmetros
 *
 * @param string $url URL base
 * @return string URL com UTMs anexados
 */
function utm_append_to_url($url)
{
    if (empty($_SESSION['utm']) || !is_array($_SESSION['utm'])) {
        return $url;
    }

    $separator = (strpos($url, '?') === false) ? '?' : '&';
    return $url . $separator . http_build_query($_SESSION['utm']);
}

/**
 * Retorna array com todas as UTMs da sessão
 *
 * @return array UTMs salvas na sessão
 */
function utm_get_all()
{
    return $_SESSION['utm'] ?? [];
}
?>
