<?php
/**
 * REENVIAR PARA UTMIFY (sem Facebook)
 */

header('Content-Type: text/plain; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/utmify.php';

$txId = $_GET['id'] ?? '1c5be10a-c31c-4c82-b770-46ef9c8ab582';

echo "=== REENVIAR PARA UTMIFY ===\n\n";

// Carrega JSON
$jsonFile = UTM_STORAGE_DIR . $txId . '.json';

if (!file_exists($jsonFile)) {
    echo "❌ Arquivo não encontrado\n";
    exit;
}

$data = json_decode(file_get_contents($jsonFile), true);

echo "Transação: $txId\n";
echo "Cliente: " . ($data['customer']['name'] ?? 'N/A') . "\n";
echo "Valor: R$ " . number_format(($data['valor_centavos'] ?? 0) / 100, 2, ',', '.') . "\n";
echo "UTM Source: " . ($data['utm_source'] ?? 'N/A') . "\n";
echo "UTM Campaign: " . substr($data['utm_campaign'] ?? 'N/A', 0, 60) . "...\n\n";

// Envia para UTMify
$utmify = new Utmify();

$result = $utmify->sendPaid(
    $txId,
    $data['valor_centavos'] ?? 0,
    [
        'name' => $data['customer']['name'] ?? '',
        'email' => $data['customer']['email'] ?? '',
        'phone' => $data['customer']['phone'] ?? '',
        'document' => $data['customer']['document'] ?? '',
        'ip' => $data['customer_ip'] ?? '127.0.0.1'
    ],
    [
        'id' => $data['produto_id'] ?? 'premios-001',
        'name' => $data['produto'] ?? 'Prêmios do Carlinhos',
        'quantity' => $data['cotas'] ?? 1
    ],
    [
        'sck' => $data['sck'] ?? '',
        'src' => $data['src'] ?? '',
        'utm_source' => $data['utm_source'] ?? '',
        'utm_medium' => $data['utm_medium'] ?? '',
        'utm_campaign' => $data['utm_campaign'] ?? '',
        'utm_content' => $data['utm_content'] ?? '',
        'utm_term' => $data['utm_term'] ?? ''
    ]
);

echo "=== RESULTADO ===\n";
echo "Success: " . ($result['success'] ? 'Sim' : 'Não') . "\n";
echo "HTTP: " . ($result['http_code'] ?? 'N/A') . "\n";
echo "Response: " . json_encode($result['response'] ?? [], JSON_PRETTY_PRINT) . "\n";