<?php
/**
 * Sistema de Proteção - Redirecionador
 * Redireciona para o painel admin ou instalador
 */

// Verificar se está instalado
$configFile = __DIR__ . '/db_config.php';

if (file_exists($configFile)) {
    // Instalado - ir para o painel
    header('Location: admin/');
    exit;
}

// Não instalado - verificar se instalador existe
$installFile = __DIR__ . '/install.php';

if (file_exists($installFile)) {
    header('Location: install.php');
    exit;
}

// Instalador foi removido/renomeado mas não há config
// Mostrar mensagem de erro
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Protetor - Não Instalado</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen flex items-center justify-center p-4">
    <div class="bg-white rounded-2xl shadow-xl max-w-md w-full p-8 text-center">
        <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-4">
            <svg class="w-8 h-8 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"/>
            </svg>
        </div>
        <h1 class="text-xl font-bold text-gray-800 mb-2">Sistema Não Instalado</h1>
        <p class="text-gray-500 mb-4">O instalador foi removido e o sistema não está configurado.</p>
        <p class="text-sm text-gray-400">Para reinstalar, restaure o arquivo <code class="bg-gray-100 px-1 rounded">install.php</code> ou renomeie o backup.</p>
    </div>
</body>
</html>
<?php exit;
