<?php
/**
 * Configurações do Sistema de Proteção
 */

// ============================================
// CONFIGURAÇÕES GERAIS
// ============================================

// Ativar/desativar proteções individuais
define('PROTETOR_PCLID_ATIVO', true);           // Exigir token pclid
define('PROTETOR_REFERER_ATIVO', true);         // Filtrar por referer
define('PROTETOR_DEVICE_ATIVO', true);          // Filtrar por dispositivo
define('PROTETOR_ANTI_CLONE_ATIVO', true);      // Proteções anti-inspeção
define('PROTETOR_DB_TRACKING_ATIVO', true);     // Salvar visitantes no banco

// URL de redirecionamento quando bloqueado
define('PROTETOR_REDIRECT_URL', './noticia/');

// ============================================
// CONFIGURAÇÃO DO TOKEN PCLID
// ============================================

// Chave secreta para gerar tokens (ALTERE ISSO!)
define('PROTETOR_SECRET_KEY', 'protetor_secret_2024_change_me');

// Tempo de validade do token em segundos (24 horas)
define('PROTETOR_TOKEN_EXPIRY', 86400);

// ============================================
// REFERERS PERMITIDOS
// ============================================

// Referers que indicam que veio de anúncio (não biblioteca)
$PROTETOR_REFERERS_PERMITIDOS = [
    'facebook.com',
    'fb.com',
    'l.facebook.com',
    'lm.facebook.com',
    'm.facebook.com',
    'instagram.com',
    'l.instagram.com',
    'ig.me',
];

// Referers bloqueados (biblioteca de anúncios, etc)
$PROTETOR_REFERERS_BLOQUEADOS = [
    'facebook.com/ads/library',
    'www.facebook.com/ads/library',
];

// ============================================
// DISPOSITIVOS
// ============================================

// Permitir apenas mobile?
define('PROTETOR_APENAS_MOBILE', true);

// User agents de bots/crawlers para bloquear
$PROTETOR_BOTS_BLOQUEADOS = [
    'bot',
    'crawler',
    'spider',
    'scraper',
    'curl',
    'wget',
    'python',
    'httpclient',
    'java',
    'libwww',
];
?>
