<?php
require_once 'auth.php';
requireAuth();

$pdo = getDB();
$prefix = PROTETOR_DB_PREFIX;

// Paginação
$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 50;
$offset = ($page - 1) * $perPage;

// Filtros
$filtroDevice = $_GET['device'] ?? '';
$filtroData = $_GET['data'] ?? '';

$where = "WHERE 1=1";
$params = [];

if ($filtroDevice) {
    $where .= " AND dispositivo = ?";
    $params[] = $filtroDevice;
}

if ($filtroData) {
    $where .= " AND DATE(validado_em) = ?";
    $params[] = $filtroData;
}

// Total
$stmtCount = $pdo->prepare("SELECT COUNT(*) FROM {$prefix}visitantes $where");
$stmtCount->execute($params);
$total = $stmtCount->fetchColumn();
$totalPages = ceil($total / $perPage);

// Dados
$stmt = $pdo->prepare("SELECT * FROM {$prefix}visitantes $where ORDER BY validado_em DESC LIMIT $perPage OFFSET $offset");
$stmt->execute($params);
$visitantes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Visitantes - Sistema de Proteção</title>
    <link rel="icon" type="image/svg+xml" href="/assets/favicon-protetor.svg">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 min-h-screen">
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                    <i class="fas fa-shield-alt text-white"></i>
                </div>
                <div>
                    <h1 class="font-bold text-gray-800">Sistema de Proteção</h1>
                    <p class="text-xs text-gray-500">Painel Administrativo</p>
                </div>
            </div>
            <nav class="flex items-center gap-4">
                <a href="index.php" class="text-gray-600 hover:text-green-500">Dashboard</a>
                <a href="settings.php" class="text-gray-600 hover:text-green-500">Configurações</a>
                <a href="visitors.php" class="text-green-500 font-medium">Visitantes</a>
                <a href="blocks.php" class="text-gray-600 hover:text-green-500">Bloqueios</a>
                <a href="tokens.php" class="text-gray-600 hover:text-green-500">Tokens</a>
                <a href="ips.php" class="text-gray-600 hover:text-green-500">IPs</a>
                <a href="logout.php" class="text-gray-400 hover:text-red-500"><i class="fas fa-sign-out-alt"></i></a>
            </nav>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        <div class="bg-white rounded-xl shadow-sm">
            <div class="px-6 py-4 border-b border-gray-100 flex items-center justify-between">
                <div>
                    <h2 class="font-bold text-gray-800">Visitantes Válidos</h2>
                    <p class="text-sm text-gray-500"><?= number_format($total) ?> registros</p>
                </div>
                <form class="flex gap-2">
                    <select name="device" class="px-3 py-2 border border-gray-300 rounded-lg text-sm">
                        <option value="">Todos dispositivos</option>
                        <option value="mobile" <?= $filtroDevice === 'mobile' ? 'selected' : '' ?>>Mobile</option>
                        <option value="desktop" <?= $filtroDevice === 'desktop' ? 'selected' : '' ?>>Desktop</option>
                        <option value="tablet" <?= $filtroDevice === 'tablet' ? 'selected' : '' ?>>Tablet</option>
                    </select>
                    <input type="date" name="data" value="<?= $filtroData ?>" class="px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    <button type="submit" class="px-4 py-2 bg-green-500 text-white rounded-lg text-sm hover:bg-green-600">Filtrar</button>
                </form>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead class="bg-gray-50">
                        <tr class="text-left text-gray-500">
                            <th class="px-6 py-3">IP</th>
                            <th class="px-6 py-3">Dispositivo</th>
                            <th class="px-6 py-3">UTM Source</th>
                            <th class="px-6 py-3">FBCLID</th>
                            <th class="px-6 py-3">Páginas</th>
                            <th class="px-6 py-3">Data</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($visitantes as $v): ?>
                        <tr class="border-b border-gray-50 hover:bg-gray-50">
                            <td class="px-6 py-3 font-mono text-xs"><?= htmlspecialchars($v['ip']) ?></td>
                            <td class="px-6 py-3">
                                <span class="px-2 py-1 rounded text-xs <?= $v['dispositivo'] === 'mobile' ? 'bg-blue-100 text-blue-700' : ($v['dispositivo'] === 'tablet' ? 'bg-purple-100 text-purple-700' : 'bg-gray-100 text-gray-600') ?>">
                                    <?= $v['dispositivo'] ?>
                                </span>
                            </td>
                            <td class="px-6 py-3 text-gray-600"><?= htmlspecialchars($v['utm_source'] ?? '-') ?></td>
                            <td class="px-6 py-3 font-mono text-xs text-gray-400"><?= $v['fbclid'] ? substr($v['fbclid'], 0, 20) . '...' : '-' ?></td>
                            <td class="px-6 py-3 text-center"><?= $v['paginas_visitadas'] ?></td>
                            <td class="px-6 py-3 text-gray-400"><?= date('d/m/Y H:i', strtotime($v['validado_em'])) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginação -->
            <?php if ($totalPages > 1): ?>
            <div class="px-6 py-4 border-t border-gray-100 flex justify-center gap-2">
                <?php for ($p = max(1, $page - 2); $p <= min($totalPages, $page + 2); $p++): ?>
                <a href="?page=<?= $p ?>&device=<?= $filtroDevice ?>&data=<?= $filtroData ?>"
                   class="px-3 py-1 rounded <?= $p === $page ? 'bg-green-500 text-white' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' ?>">
                    <?= $p ?>
                </a>
                <?php endfor; ?>
            </div>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>
