<?php
require_once 'auth.php';
requireAuth();

require_once __DIR__ . '/../pclid.php';

$pdo = getDB();
$prefix = PROTETOR_DB_PREFIX;

$message = '';
$messageType = '';

// Buscar token global atual
$stmt = $pdo->prepare("SELECT valor FROM {$prefix}config WHERE chave = 'token_global'");
$stmt->execute();
$tokenAtual = $stmt->fetchColumn();

// Se não existe token, criar um
if (!$tokenAtual) {
    $tokenAtual = pclid_gerar(365 * 24 * 3600); // 1 ano de validade
    $stmt = $pdo->prepare("INSERT INTO {$prefix}config (chave, valor, tipo, descricao, grupo) VALUES ('token_global', ?, 'string', 'Token PCLID global único', 'geral') ON DUPLICATE KEY UPDATE valor = ?");
    $stmt->execute([$tokenAtual, $tokenAtual]);
}

// Regenerar token
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['regenerar'])) {
    $expiry = (int)($_POST['expiry'] ?? 365 * 24 * 3600);
    $tokenAtual = pclid_gerar($expiry);

    $stmt = $pdo->prepare("UPDATE {$prefix}config SET valor = ? WHERE chave = 'token_global'");
    $stmt->execute([$tokenAtual]);

    $message = 'Token regenerado com sucesso! O token anterior foi invalidado.';
    $messageType = 'success';
}

// Decodificar para mostrar info
$tokenInfo = pclid_validar($tokenAtual);

// Pegar URL base do site (configuração ou inferir)
$siteUrl = getConfig('site_url', '');
if (!$siteUrl) {
    $siteUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'seusite.com');
    // Remover /protetor/admin da URL
    $siteUrl = preg_replace('#/protetor/admin.*$#', '', $siteUrl);
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Token - Sistema de Proteção</title>
    <link rel="icon" type="image/svg+xml" href="/assets/favicon-protetor.svg">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 min-h-screen">
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                    <i class="fas fa-shield-alt text-white"></i>
                </div>
                <div>
                    <h1 class="font-bold text-gray-800">Sistema de Proteção</h1>
                    <p class="text-xs text-gray-500">Painel Administrativo</p>
                </div>
            </div>
            <nav class="flex items-center gap-4">
                <a href="index.php" class="text-gray-600 hover:text-green-500">Dashboard</a>
                <a href="settings.php" class="text-gray-600 hover:text-green-500">Configurações</a>
                <a href="visitors.php" class="text-gray-600 hover:text-green-500">Visitantes</a>
                <a href="blocks.php" class="text-gray-600 hover:text-green-500">Bloqueios</a>
                <a href="tokens.php" class="text-green-500 font-medium">Tokens</a>
                <a href="ips.php" class="text-gray-600 hover:text-green-500">IPs</a>
                <a href="logout.php" class="text-gray-400 hover:text-red-500"><i class="fas fa-sign-out-alt"></i></a>
            </nav>
        </div>
    </header>

    <main class="max-w-4xl mx-auto px-4 py-8">
        <?php if ($message): ?>
        <div class="mb-4 p-4 rounded-lg <?= $messageType === 'success' ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700' ?>">
            <i class="fas fa-<?= $messageType === 'success' ? 'check' : 'exclamation' ?>-circle mr-2"></i><?= htmlspecialchars($message) ?>
        </div>
        <?php endif; ?>

        <!-- Token Único -->
        <div class="bg-white rounded-xl shadow-sm p-6 mb-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h2 class="font-bold text-gray-800 text-xl">
                        <i class="fas fa-key mr-2 text-green-500"></i>Token PCLID Único
                    </h2>
                    <p class="text-gray-500 text-sm mt-1">Este é o token único para proteger suas URLs</p>
                </div>
                <?php if ($tokenInfo && isset($tokenInfo['valido']) && $tokenInfo['valido']): ?>
                <span class="px-3 py-1 rounded-full text-sm bg-green-100 text-green-700">
                    <i class="fas fa-check-circle mr-1"></i>Ativo
                </span>
                <?php else: ?>
                <span class="px-3 py-1 rounded-full text-sm bg-red-100 text-red-700">
                    <i class="fas fa-times-circle mr-1"></i>Expirado
                </span>
                <?php endif; ?>
            </div>

            <!-- Token Display -->
            <div class="bg-gray-50 rounded-lg p-4 mb-4">
                <label class="block text-sm font-medium text-gray-600 mb-2">Seu Token:</label>
                <div class="flex gap-2">
                    <input type="text" id="tokenValue" value="<?= htmlspecialchars($tokenAtual) ?>" readonly
                        class="flex-1 px-4 py-3 bg-white border border-gray-200 rounded-lg font-mono text-sm">
                    <button onclick="copyToClipboard('tokenValue')" class="px-4 py-3 bg-green-500 text-white rounded-lg hover:bg-green-600 transition">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
            </div>

            <?php if ($tokenInfo && isset($tokenInfo['tempo_restante'])): ?>
            <div class="text-sm text-gray-500 mb-4">
                <i class="fas fa-clock mr-1"></i>
                Expira em: <strong><?= number_format($tokenInfo['tempo_restante'] / 86400, 0) ?> dias</strong>
                (<?= date('d/m/Y H:i', $tokenInfo['expira_em']) ?>)
            </div>
            <?php endif; ?>

            <!-- Regenerar Token -->
            <div class="border-t border-gray-100 pt-4 mt-4">
                <form method="POST" class="flex items-end gap-4" onsubmit="return confirm('Tem certeza? O token atual será invalidado e todas as URLs com ele deixarão de funcionar!');">
                    <div class="flex-1">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Validade do Novo Token</label>
                        <select name="expiry" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                            <option value="2592000">30 dias</option>
                            <option value="7776000">90 dias</option>
                            <option value="15552000">180 dias</option>
                            <option value="31536000" selected>1 ano</option>
                            <option value="63072000">2 anos</option>
                        </select>
                    </div>
                    <button type="submit" name="regenerar" value="1" class="px-6 py-2 bg-red-500 text-white rounded-lg font-medium hover:bg-red-600 transition">
                        <i class="fas fa-sync-alt mr-2"></i>Regenerar Token
                    </button>
                </form>
            </div>
        </div>

        <!-- URL de Exemplo -->
        <div class="bg-white rounded-xl shadow-sm p-6 mb-6">
            <h3 class="font-bold text-gray-800 mb-4">
                <i class="fas fa-link mr-2 text-blue-500"></i>URL para seus Anúncios
            </h3>

            <div class="bg-gray-50 rounded-lg p-4">
                <label class="block text-sm font-medium text-gray-600 mb-2">URL com Token:</label>
                <div class="flex gap-2">
                    <input type="text" id="urlCompleta"
                        value="<?= htmlspecialchars($siteUrl) ?>/?pclid=<?= htmlspecialchars($tokenAtual) ?>"
                        readonly
                        class="flex-1 px-4 py-3 bg-white border border-gray-200 rounded-lg font-mono text-xs">
                    <button onclick="copyToClipboard('urlCompleta')" class="px-4 py-3 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
            </div>

            <div class="mt-4 text-sm text-gray-500">
                <p><i class="fas fa-info-circle mr-1"></i> Você pode adicionar UTMs à URL normalmente:</p>
                <code class="block mt-2 p-3 bg-gray-100 rounded text-xs">
                    <?= htmlspecialchars($siteUrl) ?>/?pclid=<?= htmlspecialchars(substr($tokenAtual, 0, 20)) ?>...&utm_source=facebook&utm_medium=cpc
                </code>
            </div>
        </div>

        <!-- Como Usar -->
        <div class="bg-white rounded-xl shadow-sm p-6">
            <h3 class="font-bold text-gray-800 mb-4">
                <i class="fas fa-question-circle mr-2 text-yellow-500"></i>Como Usar o Token
            </h3>

            <div class="space-y-4 text-sm text-gray-600">
                <div class="flex gap-3">
                    <span class="w-6 h-6 bg-green-100 text-green-600 rounded-full flex items-center justify-center flex-shrink-0 text-xs font-bold">1</span>
                    <p>Copie a URL completa com o token acima</p>
                </div>
                <div class="flex gap-3">
                    <span class="w-6 h-6 bg-green-100 text-green-600 rounded-full flex items-center justify-center flex-shrink-0 text-xs font-bold">2</span>
                    <p>Use essa URL nos seus anúncios do Facebook/Instagram</p>
                </div>
                <div class="flex gap-3">
                    <span class="w-6 h-6 bg-green-100 text-green-600 rounded-full flex items-center justify-center flex-shrink-0 text-xs font-bold">3</span>
                    <p>Adicione os parâmetros UTM conforme necessário (utm_source, utm_medium, etc)</p>
                </div>
                <div class="flex gap-3">
                    <span class="w-6 h-6 bg-green-100 text-green-600 rounded-full flex items-center justify-center flex-shrink-0 text-xs font-bold">4</span>
                    <p>Visitantes que acessarem sem o token serão bloqueados (se o filtro estiver ativo)</p>
                </div>
            </div>

            <div class="mt-6 p-4 bg-yellow-50 rounded-lg">
                <p class="text-yellow-700 text-sm">
                    <i class="fas fa-exclamation-triangle mr-1"></i>
                    <strong>Importante:</strong> Se você regenerar o token, todas as URLs antigas com o token anterior deixarão de funcionar.
                    Você precisará atualizar suas campanhas de anúncios.
                </p>
            </div>
        </div>
    </main>

    <script>
    function copyToClipboard(elementId) {
        const element = document.getElementById(elementId);
        element.select();
        document.execCommand('copy');

        // Feedback visual
        const btn = element.nextElementSibling;
        const originalIcon = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i>';
        btn.classList.remove('bg-green-500', 'bg-blue-500');
        btn.classList.add('bg-green-500');

        setTimeout(() => {
            btn.innerHTML = originalIcon;
            btn.classList.remove('bg-green-500');
            if (elementId === 'tokenValue') {
                btn.classList.add('bg-green-500');
            } else {
                btn.classList.add('bg-blue-500');
            }
        }, 1500);
    }
    </script>
</body>
</html>
