<?php
require_once 'auth.php';
requireAuth();

$pdo = getDB();
$prefix = PROTETOR_DB_PREFIX;

// Processar formulário
$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $grupo = $_POST['grupo'] ?? '';
    $configs = $_POST['config'] ?? [];

    foreach ($configs as $chave => $valor) {
        // Checkboxes não enviados = false
        setConfig($chave, $valor);
    }

    // Processar checkboxes (os não marcados não são enviados)
    $allConfigs = getConfigsByGroup($grupo);
    foreach ($allConfigs as $chave => $data) {
        if ($data['tipo'] === 'bool' && !isset($configs[$chave])) {
            setConfig($chave, '0');
        }
    }

    $message = 'Configurações salvas com sucesso!';
    $messageType = 'success';
}

// Grupos de configuração
$grupos = getConfigGroups();
$grupoAtivo = $_GET['grupo'] ?? ($grupos[0] ?? 'geral');
$configs = getConfigsByGroup($grupoAtivo);

// Labels amigáveis para os grupos
$grupoLabels = [
    'geral' => ['label' => 'Geral', 'icon' => 'fa-cog'],
    'filtros' => ['label' => 'Filtros', 'icon' => 'fa-filter'],
    'dispositivos' => ['label' => 'Dispositivos', 'icon' => 'fa-mobile-alt'],
    'utms' => ['label' => 'UTMs', 'icon' => 'fa-tags'],
    'referer' => ['label' => 'Referer', 'icon' => 'fa-link'],
    'anticlone' => ['label' => 'Anti-Clone', 'icon' => 'fa-shield-alt'],
    'bots' => ['label' => 'Bots', 'icon' => 'fa-robot'],
    'geo' => ['label' => 'Geolocalização', 'icon' => 'fa-globe'],
    'tracking' => ['label' => 'Tracking', 'icon' => 'fa-chart-line'],
    'scripts' => ['label' => 'Scripts', 'icon' => 'fa-code'],
];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações - Sistema de Proteção</title>
    <link rel="icon" type="image/svg+xml" href="/assets/favicon-protetor.svg">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                    <i class="fas fa-shield-alt text-white"></i>
                </div>
                <div>
                    <h1 class="font-bold text-gray-800">Sistema de Proteção</h1>
                    <p class="text-xs text-gray-500">Painel Administrativo</p>
                </div>
            </div>
            <nav class="flex items-center gap-4">
                <a href="index.php" class="text-gray-600 hover:text-green-500">Dashboard</a>
                <a href="settings.php" class="text-green-500 font-medium">Configurações</a>
                <a href="visitors.php" class="text-gray-600 hover:text-green-500">Visitantes</a>
                <a href="blocks.php" class="text-gray-600 hover:text-green-500">Bloqueios</a>
                <a href="tokens.php" class="text-gray-600 hover:text-green-500">Tokens</a>
                <a href="ips.php" class="text-gray-600 hover:text-green-500">IPs</a>
                <a href="logout.php" class="text-gray-400 hover:text-red-500"><i class="fas fa-sign-out-alt"></i></a>
            </nav>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        <div class="flex gap-8">
            <!-- Sidebar de Grupos -->
            <div class="w-64 flex-shrink-0">
                <div class="bg-white rounded-xl shadow-sm p-4">
                    <h3 class="font-semibold text-gray-700 mb-3">Categorias</h3>
                    <nav class="space-y-1">
                        <?php foreach ($grupos as $grupo): ?>
                        <?php $info = $grupoLabels[$grupo] ?? ['label' => ucfirst($grupo), 'icon' => 'fa-folder']; ?>
                        <a href="?grupo=<?= $grupo ?>"
                           class="flex items-center gap-3 px-3 py-2 rounded-lg transition <?= $grupo === $grupoAtivo ? 'bg-green-50 text-green-600' : 'text-gray-600 hover:bg-gray-50' ?>">
                            <i class="fas <?= $info['icon'] ?> w-5 text-center"></i>
                            <span><?= $info['label'] ?></span>
                        </a>
                        <?php endforeach; ?>
                    </nav>
                </div>
            </div>

            <!-- Formulário de Configurações -->
            <div class="flex-1">
                <?php if ($message): ?>
                <div class="mb-4 p-4 rounded-lg <?= $messageType === 'success' ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700' ?>">
                    <i class="fas fa-check-circle mr-2"></i><?= htmlspecialchars($message) ?>
                </div>
                <?php endif; ?>

                <div class="bg-white rounded-xl shadow-sm">
                    <div class="px-6 py-4 border-b border-gray-100">
                        <h2 class="font-bold text-gray-800">
                            <?= $grupoLabels[$grupoAtivo]['label'] ?? ucfirst($grupoAtivo) ?>
                        </h2>
                    </div>

                    <form method="POST" class="p-6">
                        <input type="hidden" name="grupo" value="<?= $grupoAtivo ?>">

                        <div class="space-y-6">
                            <?php foreach ($configs as $chave => $data): ?>
                            <div class="flex items-start justify-between py-3 border-b border-gray-50 last:border-0">
                                <div class="flex-1">
                                    <label class="font-medium text-gray-700" for="<?= $chave ?>">
                                        <?= htmlspecialchars($data['descricao']) ?>
                                    </label>
                                    <p class="text-xs text-gray-400 mt-1"><?= $chave ?></p>
                                </div>

                                <div class="ml-4">
                                    <?php if ($data['tipo'] === 'bool'): ?>
                                    <!-- Toggle Switch -->
                                    <label class="relative inline-flex items-center cursor-pointer">
                                        <input type="checkbox"
                                               name="config[<?= $chave ?>]"
                                               value="1"
                                               <?= $data['valor'] ? 'checked' : '' ?>
                                               class="sr-only peer">
                                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-2 peer-focus:ring-green-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-500"></div>
                                    </label>

                                    <?php elseif ($data['tipo'] === 'int'): ?>
                                    <input type="number"
                                           name="config[<?= $chave ?>]"
                                           value="<?= htmlspecialchars($data['valor']) ?>"
                                           class="w-32 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent text-sm">

                                    <?php elseif ($data['tipo'] === 'json'): ?>
                                    <textarea name="config[<?= $chave ?>]"
                                              rows="2"
                                              class="w-64 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent text-xs font-mono"
                                    ><?= htmlspecialchars(json_encode($data['valor'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)) ?></textarea>

                                    <?php else: ?>
                                    <input type="text"
                                           name="config[<?= $chave ?>]"
                                           value="<?= htmlspecialchars($data['valor']) ?>"
                                           class="w-64 px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent text-sm">
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="mt-6 pt-6 border-t border-gray-100">
                            <button type="submit" class="bg-green-500 text-white px-6 py-2 rounded-lg font-medium hover:bg-green-600 transition">
                                <i class="fas fa-save mr-2"></i>Salvar Configurações
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
</body>
</html>
