<?php
require_once 'auth.php';
requireAuth();

$pdo = getDB();
$prefix = PROTETOR_DB_PREFIX;

// Obter IP do visitante atual
$meuIP = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_X_REAL_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
if (strpos($meuIP, ',') !== false) {
    $meuIP = trim(explode(',', $meuIP)[0]);
}

// Estatísticas
$stats = [
    'total_visitantes' => 0,
    'total_bloqueados' => 0,
    'visitantes_hoje' => 0,
    'bloqueados_hoje' => 0,
    'mobile' => 0,
    'desktop' => 0,
    'tablet' => 0,
];

try {
    // Total visitantes
    $stmt = $pdo->query("SELECT COUNT(*) FROM {$prefix}visitantes WHERE bloqueado = 0");
    $stats['total_visitantes'] = $stmt->fetchColumn();

    // Total bloqueados
    $stmt = $pdo->query("SELECT COUNT(*) FROM {$prefix}bloqueios");
    $stats['total_bloqueados'] = $stmt->fetchColumn();

    // Visitantes hoje
    $stmt = $pdo->query("SELECT COUNT(*) FROM {$prefix}visitantes WHERE DATE(validado_em) = CURDATE()");
    $stats['visitantes_hoje'] = $stmt->fetchColumn();

    // Bloqueados hoje
    $stmt = $pdo->query("SELECT COUNT(*) FROM {$prefix}bloqueios WHERE DATE(criado_em) = CURDATE()");
    $stats['bloqueados_hoje'] = $stmt->fetchColumn();

    // Por dispositivo
    $stmt = $pdo->query("SELECT dispositivo, COUNT(*) as total FROM {$prefix}visitantes GROUP BY dispositivo");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $stats[$row['dispositivo']] = $row['total'];
    }

    // Últimos visitantes
    $stmt = $pdo->query("SELECT * FROM {$prefix}visitantes ORDER BY validado_em DESC LIMIT 10");
    $ultimosVisitantes = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Últimos bloqueios
    $stmt = $pdo->query("SELECT * FROM {$prefix}bloqueios ORDER BY criado_em DESC LIMIT 10");
    $ultimosBloqueios = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    $ultimosVisitantes = [];
    $ultimosBloqueios = [];
}

// Status das proteções
$protecoes = [
    'filtro_ativo' => getConfig('filtro_ativo', false),
    'filtro_pclid' => getConfig('filtro_pclid', false),
    'filtro_referer' => getConfig('filtro_referer', false),
    'filtro_device' => getConfig('filtro_device', false),
    'filtro_utm' => getConfig('filtro_utm', false),
    'filtro_bot' => getConfig('filtro_bot', false),
    'anti_devtools' => getConfig('anti_devtools', false),
    'anti_rightclick' => getConfig('anti_rightclick', false),
];
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema de Proteção</title>
    <link rel="icon" type="image/svg+xml" href="/assets/favicon-protetor.svg">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 min-h-screen">
    <!-- Header -->
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                    <i class="fas fa-shield-alt text-white"></i>
                </div>
                <div>
                    <h1 class="font-bold text-gray-800">Sistema de Proteção</h1>
                    <p class="text-xs text-gray-500">Painel Administrativo</p>
                </div>
            </div>
            <nav class="flex items-center gap-4">
                <a href="index.php" class="text-green-500 font-medium">Dashboard</a>
                <a href="settings.php" class="text-gray-600 hover:text-green-500">Configurações</a>
                <a href="visitors.php" class="text-gray-600 hover:text-green-500">Visitantes</a>
                <a href="blocks.php" class="text-gray-600 hover:text-green-500">Bloqueios</a>
                <a href="tokens.php" class="text-gray-600 hover:text-green-500">Tokens</a>
                <a href="ips.php" class="text-gray-600 hover:text-green-500">IPs</a>
                <a href="logout.php" class="text-gray-400 hover:text-red-500"><i class="fas fa-sign-out-alt"></i></a>
            </nav>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Visitantes Válidos</p>
                        <p class="text-3xl font-bold text-gray-800"><?= number_format($stats['total_visitantes']) ?></p>
                        <p class="text-xs text-green-500 mt-1">+<?= $stats['visitantes_hoje'] ?> hoje</p>
                    </div>
                    <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-users text-green-500"></i>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Acessos Bloqueados</p>
                        <p class="text-3xl font-bold text-gray-800"><?= number_format($stats['total_bloqueados']) ?></p>
                        <p class="text-xs text-red-500 mt-1">+<?= $stats['bloqueados_hoje'] ?> hoje</p>
                    </div>
                    <div class="w-12 h-12 bg-red-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-ban text-red-500"></i>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Mobile</p>
                        <p class="text-3xl font-bold text-gray-800"><?= number_format($stats['mobile']) ?></p>
                        <p class="text-xs text-gray-400 mt-1">dispositivos móveis</p>
                    </div>
                    <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-mobile-alt text-blue-500"></i>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm text-gray-500">Desktop</p>
                        <p class="text-3xl font-bold text-gray-800"><?= number_format($stats['desktop']) ?></p>
                        <p class="text-xs text-gray-400 mt-1">computadores</p>
                    </div>
                    <div class="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-desktop text-purple-500"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Meu IP -->
        <div class="bg-white rounded-xl shadow-sm p-4 mb-8 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-network-wired text-blue-500"></i>
                </div>
                <div>
                    <p class="text-sm text-gray-500">Seu IP atual</p>
                    <p class="font-mono font-bold text-gray-800" id="meuIP"><?= htmlspecialchars($meuIP) ?></p>
                </div>
            </div>
            <div class="flex gap-2">
                <button onclick="copiarIP()" class="px-4 py-2 bg-blue-500 text-white rounded-lg text-sm hover:bg-blue-600 transition">
                    <i class="fas fa-copy mr-1"></i> Copiar
                </button>
                <a href="ips.php" class="px-4 py-2 bg-green-500 text-white rounded-lg text-sm hover:bg-green-600 transition">
                    <i class="fas fa-plus mr-1"></i> Adicionar à Whitelist
                </a>
            </div>
        </div>

        <!-- Status das Proteções -->
        <div class="bg-white rounded-xl shadow-sm p-6 mb-8">
            <h2 class="font-bold text-gray-800 mb-4">Status das Proteções</h2>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <?php foreach ($protecoes as $key => $ativo): ?>
                <div class="flex items-center gap-2 p-3 rounded-lg <?= $ativo ? 'bg-green-50' : 'bg-gray-50' ?>">
                    <div class="w-3 h-3 rounded-full <?= $ativo ? 'bg-green-500' : 'bg-gray-300' ?>"></div>
                    <span class="text-sm <?= $ativo ? 'text-green-700' : 'text-gray-500' ?>">
                        <?= ucfirst(str_replace('_', ' ', $key)) ?>
                    </span>
                </div>
                <?php endforeach; ?>
            </div>
            <div class="mt-4">
                <a href="settings.php" class="text-green-500 text-sm hover:underline">
                    <i class="fas fa-cog mr-1"></i> Gerenciar configurações
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Últimos Visitantes -->
            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="font-bold text-gray-800">Últimos Visitantes</h2>
                    <a href="visitors.php" class="text-green-500 text-sm hover:underline">Ver todos</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="text-left text-gray-500 border-b">
                                <th class="pb-2">IP</th>
                                <th class="pb-2">Dispositivo</th>
                                <th class="pb-2">UTM Source</th>
                                <th class="pb-2">Data</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($ultimosVisitantes)): ?>
                            <tr><td colspan="4" class="py-4 text-center text-gray-400">Nenhum visitante ainda</td></tr>
                            <?php else: ?>
                            <?php foreach ($ultimosVisitantes as $v): ?>
                            <tr class="border-b border-gray-50">
                                <td class="py-2 font-mono text-xs"><?= htmlspecialchars($v['ip']) ?></td>
                                <td class="py-2">
                                    <span class="px-2 py-1 rounded text-xs <?= $v['dispositivo'] === 'mobile' ? 'bg-blue-100 text-blue-700' : 'bg-gray-100 text-gray-600' ?>">
                                        <?= $v['dispositivo'] ?>
                                    </span>
                                </td>
                                <td class="py-2 text-gray-600"><?= htmlspecialchars($v['utm_source'] ?? '-') ?></td>
                                <td class="py-2 text-gray-400 text-xs"><?= date('d/m H:i', strtotime($v['validado_em'])) ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Últimos Bloqueios -->
            <div class="bg-white rounded-xl shadow-sm p-6">
                <div class="flex items-center justify-between mb-4">
                    <h2 class="font-bold text-gray-800">Últimos Bloqueios</h2>
                    <a href="blocks.php" class="text-green-500 text-sm hover:underline">Ver todos</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead>
                            <tr class="text-left text-gray-500 border-b">
                                <th class="pb-2">IP</th>
                                <th class="pb-2">Motivo</th>
                                <th class="pb-2">Data</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($ultimosBloqueios)): ?>
                            <tr><td colspan="3" class="py-4 text-center text-gray-400">Nenhum bloqueio ainda</td></tr>
                            <?php else: ?>
                            <?php foreach ($ultimosBloqueios as $b): ?>
                            <tr class="border-b border-gray-50">
                                <td class="py-2 font-mono text-xs"><?= htmlspecialchars($b['ip']) ?></td>
                                <td class="py-2">
                                    <span class="px-2 py-1 rounded text-xs bg-red-100 text-red-700">
                                        <?= htmlspecialchars($b['motivo']) ?>
                                    </span>
                                </td>
                                <td class="py-2 text-gray-400 text-xs"><?= date('d/m H:i', strtotime($b['criado_em'])) ?></td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
    <script>
    function copiarIP() {
        const ip = document.getElementById('meuIP').textContent;
        navigator.clipboard.writeText(ip).then(() => {
            alert('IP copiado: ' + ip);
        });
    }
    </script>
</body>
</html>
