<?php
require_once 'auth.php';
requireAuth();

$pdo = getDB();
$prefix = PROTETOR_DB_PREFIX;

// Paginação
$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 50;
$offset = ($page - 1) * $perPage;

// Filtros
$filtroMotivo = $_GET['motivo'] ?? '';
$filtroIP = $_GET['ip'] ?? '';
$filtroData = $_GET['data'] ?? '';

$where = "WHERE 1=1";
$params = [];

if ($filtroMotivo) {
    $where .= " AND motivo LIKE ?";
    $params[] = "%$filtroMotivo%";
}

if ($filtroIP) {
    $where .= " AND ip LIKE ?";
    $params[] = "%$filtroIP%";
}

if ($filtroData) {
    $where .= " AND DATE(criado_em) = ?";
    $params[] = $filtroData;
}

// Total
$stmtCount = $pdo->prepare("SELECT COUNT(*) FROM {$prefix}bloqueios $where");
$stmtCount->execute($params);
$total = $stmtCount->fetchColumn();
$totalPages = ceil($total / $perPage);

// Dados
$stmt = $pdo->prepare("SELECT * FROM {$prefix}bloqueios $where ORDER BY criado_em DESC LIMIT $perPage OFFSET $offset");
$stmt->execute($params);
$bloqueios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Estatísticas de motivos
$stmtMotivos = $pdo->query("SELECT motivo, COUNT(*) as total FROM {$prefix}bloqueios GROUP BY motivo ORDER BY total DESC LIMIT 10");
$motivosStats = $stmtMotivos->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bloqueios - Sistema de Proteção</title>
    <link rel="icon" type="image/svg+xml" href="/assets/favicon-protetor.svg">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>body { font-family: 'Inter', sans-serif; }</style>
</head>
<body class="bg-gray-100 min-h-screen">
    <header class="bg-white shadow-sm">
        <div class="max-w-7xl mx-auto px-4 py-4 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center">
                    <i class="fas fa-shield-alt text-white"></i>
                </div>
                <div>
                    <h1 class="font-bold text-gray-800">Sistema de Proteção</h1>
                    <p class="text-xs text-gray-500">Painel Administrativo</p>
                </div>
            </div>
            <nav class="flex items-center gap-4">
                <a href="index.php" class="text-gray-600 hover:text-green-500">Dashboard</a>
                <a href="settings.php" class="text-gray-600 hover:text-green-500">Configurações</a>
                <a href="visitors.php" class="text-gray-600 hover:text-green-500">Visitantes</a>
                <a href="blocks.php" class="text-green-500 font-medium">Bloqueios</a>
                <a href="tokens.php" class="text-gray-600 hover:text-green-500">Tokens</a>
                <a href="ips.php" class="text-gray-600 hover:text-green-500">IPs</a>
                <a href="logout.php" class="text-gray-400 hover:text-red-500"><i class="fas fa-sign-out-alt"></i></a>
            </nav>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        <!-- Stats por Motivo -->
        <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-6">
            <?php foreach (array_slice($motivosStats, 0, 5) as $motivo => $count): ?>
            <div class="bg-white rounded-xl shadow-sm p-4">
                <p class="text-2xl font-bold text-red-500"><?= number_format($count) ?></p>
                <p class="text-xs text-gray-500 truncate"><?= htmlspecialchars($motivo) ?></p>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="bg-white rounded-xl shadow-sm">
            <div class="px-6 py-4 border-b border-gray-100 flex items-center justify-between flex-wrap gap-4">
                <div>
                    <h2 class="font-bold text-gray-800">Log de Bloqueios</h2>
                    <p class="text-sm text-gray-500"><?= number_format($total) ?> registros</p>
                </div>
                <form class="flex gap-2 flex-wrap">
                    <input type="text" name="ip" value="<?= htmlspecialchars($filtroIP) ?>" placeholder="IP" class="px-3 py-2 border border-gray-300 rounded-lg text-sm w-32">
                    <select name="motivo" class="px-3 py-2 border border-gray-300 rounded-lg text-sm">
                        <option value="">Todos motivos</option>
                        <?php foreach (array_keys($motivosStats) as $m): ?>
                        <option value="<?= htmlspecialchars($m) ?>" <?= $filtroMotivo === $m ? 'selected' : '' ?>><?= htmlspecialchars($m) ?></option>
                        <?php endforeach; ?>
                    </select>
                    <input type="date" name="data" value="<?= $filtroData ?>" class="px-3 py-2 border border-gray-300 rounded-lg text-sm">
                    <button type="submit" class="px-4 py-2 bg-green-500 text-white rounded-lg text-sm hover:bg-green-600">Filtrar</button>
                </form>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead class="bg-gray-50">
                        <tr class="text-left text-gray-500">
                            <th class="px-6 py-3">IP</th>
                            <th class="px-6 py-3">Motivo</th>
                            <th class="px-6 py-3">User Agent</th>
                            <th class="px-6 py-3">Referer</th>
                            <th class="px-6 py-3">Data</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($bloqueios as $b): ?>
                        <tr class="border-b border-gray-50 hover:bg-red-50">
                            <td class="px-6 py-3 font-mono text-xs"><?= htmlspecialchars($b['ip']) ?></td>
                            <td class="px-6 py-3">
                                <span class="px-2 py-1 rounded text-xs bg-red-100 text-red-700">
                                    <?= htmlspecialchars($b['motivo']) ?>
                                </span>
                            </td>
                            <td class="px-6 py-3 text-gray-500 text-xs max-w-xs truncate" title="<?= htmlspecialchars($b['user_agent'] ?? '') ?>">
                                <?= htmlspecialchars(substr($b['user_agent'] ?? '-', 0, 50)) ?>...
                            </td>
                            <td class="px-6 py-3 text-gray-500 text-xs max-w-xs truncate" title="<?= htmlspecialchars($b['referer'] ?? '') ?>">
                                <?= htmlspecialchars($b['referer'] ? substr($b['referer'], 0, 30) : '-') ?>
                            </td>
                            <td class="px-6 py-3 text-gray-400"><?= date('d/m/Y H:i:s', strtotime($b['criado_em'])) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <!-- Paginação -->
            <?php if ($totalPages > 1): ?>
            <div class="px-6 py-4 border-t border-gray-100 flex justify-center gap-2">
                <?php for ($p = max(1, $page - 2); $p <= min($totalPages, $page + 2); $p++): ?>
                <a href="?page=<?= $p ?>&motivo=<?= urlencode($filtroMotivo) ?>&ip=<?= urlencode($filtroIP) ?>&data=<?= $filtroData ?>"
                   class="px-3 py-1 rounded <?= $p === $page ? 'bg-green-500 text-white' : 'bg-gray-100 text-gray-600 hover:bg-gray-200' ?>">
                    <?= $p ?>
                </a>
                <?php endfor; ?>
            </div>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>
