# Sistema de Proteção

Sistema completo de proteção anti-clonagem para sites de e-commerce e landing pages.

## Funcionalidades

- **Filtro de UTMs**: Bloqueia acessos sem parâmetros UTM obrigatórios
- **Filtro de Referer**: Permite apenas acessos vindos do Facebook/Instagram
- **Filtro de Dispositivo**: Bloqueia acessos de desktop (permite apenas mobile)
- **Token PCLID**: Gera tokens únicos para URLs de anúncios
- **Detecção de Bots**: Bloqueia crawlers, scrapers e bots conhecidos
- **Detecção de VPN/Proxy**: Identifica e bloqueia VPNs, proxies e datacenters
- **Detecção de Datacenters**: Bloqueia IPs de AWS, Google Cloud, Azure, DigitalOcean, etc.
- **Proteções Anti-Clone**: Desabilita inspeção, clique direito, atalhos, etc.
- **Gerenciamento de IPs**: Whitelist e Blacklist de IPs com suporte a CIDR
- **Painel Admin**: Dashboard com estatísticas, configurações e credenciais próprias

---

## Instalação

### 1. Copie a pasta `protetor` para seu projeto

```
/seu-projeto/
├── protetor/
│   ├── admin/
│   ├── install.php
│   ├── protetor.php
│   ├── detector.php
│   └── ...
├── index.php
└── ...
```

### 2. Acesse o instalador

Abra no navegador: `http://seusite.com/protetor/` (ou `install.php`)

Preencha:
- **Banco de Dados**
  - Host (geralmente `localhost`)
  - Nome do banco de dados
  - Usuário e senha do banco
  - Prefixo das tabelas (ex: `protetor_`)
- **Credenciais do Painel**
  - Usuário admin (ex: `admin`)
  - Senha do painel (mínimo 6 caracteres)
- **Configuração de Bloqueio**
  - URL de redirecionamento quando bloquear visitantes

### 3. Acesse o painel admin

Após instalação: `http://seusite.com/protetor/admin/`

Use as credenciais definidas na instalação.

**Nota de Segurança:** O arquivo `install.php` é automaticamente renomeado para `install_YYYYMMDD_HHMMSS_backup.php` após a instalação, impedindo que alguém reinstale o sistema. Para reinstalar, renomeie o backup de volta para `install.php`.

---

## Painel Admin

O painel possui as seguintes seções:

| Seção | Descrição |
|-------|-----------|
| **Dashboard** | Estatísticas gerais, últimos visitantes e bloqueios |
| **Configurações** | Todas as opções de filtros e proteções |
| **Visitantes** | Lista de visitantes que passaram nos filtros |
| **Bloqueios** | Log de acessos bloqueados com motivos |
| **Tokens** | Gerador de tokens PCLID para URLs |
| **IPs** | Gerenciamento de whitelist e blacklist |

---

## Como Integrar em Suas Páginas

### Integração Básica (Página de Entrada)

Use na página principal onde os visitantes chegam pelo anúncio:

```php
<?php
// No INÍCIO do arquivo, antes de qualquer HTML
require_once __DIR__ . '/protetor/protetor.php';
protetor_verificar(); // Bloqueia se não passar nos filtros
?>
<!DOCTYPE html>
<html>
<head>
    <?= protetor_head() ?> <!-- CSS e meta tags de proteção -->
    <!-- seu código -->
</head>
<body>
    <!-- seu conteúdo -->

    <?= protetor_body() ?> <!-- Scripts de proteção -->
</body>
</html>
```

### Integração para Páginas Internas

Para páginas que o usuário acessa depois de já ter passado pela validação:

```php
<?php
require_once __DIR__ . '/protetor/protetor.php';
protetor_verificar_com_cache(); // Usa cache da sessão
?>
```

### Apenas Proteções Anti-Clone (sem filtros)

Se você quer apenas as proteções de JavaScript sem os filtros:

```php
<?php
require_once __DIR__ . '/protetor/protetor.php';
// Não chama protetor_verificar()
?>
<!DOCTYPE html>
<html>
<head>
    <?= protetor_head() ?>
</head>
<body>
    <!-- conteúdo -->
    <?= protetor_body() ?>
</body>
</html>
```

---

## Configurações via Painel Admin

Acesse `http://seusite.com/protetor/admin/` e vá em **Configurações**.

### Categorias de Configuração

| Categoria | Descrição |
|-----------|-----------|
| **Geral** | Ativar/desativar protetor, URL de redirecionamento |
| **Filtros** | Liga/desliga cada tipo de filtro (VPN, bots, device, etc) |
| **Dispositivos** | Configurar bloqueio de desktop/tablet |
| **UTMs** | Definir UTMs obrigatórias |
| **Referer** | Domínios permitidos e bloqueados |
| **Anti-Clone** | Ativar proteções individuais (devtools, clique direito, etc) |
| **Bots** | User agents e ISPs/Datacenters para bloquear |
| **Geo** | Países permitidos e bloqueio de datacenters europeus |
| **Tracking** | Configurar logs e registro de visitantes |
| **Scripts** | Clarity, Facebook Pixel e scripts customizados |

---

## Scripts de Tracking (Clarity, Facebook Pixel)

O protetor centraliza os scripts de tracking para todas as páginas protegidas. Configure uma vez no painel e eles serão inseridos automaticamente em todas as páginas.

### Microsoft Clarity

1. Acesse o painel admin > **Configurações** > **Scripts**
2. Preencha o campo **clarity_id** com seu ID (ex: `abc123xyz`)
3. O script será inserido automaticamente no `<head>` de todas as páginas

**Onde encontrar o ID:**
- Acesse https://clarity.microsoft.com
- Vá em Setup > Settings > General
- Copie o ID do projeto (a parte após `/tag/`)

### Facebook Pixel

1. Acesse o painel admin > **Configurações** > **Scripts**
2. Preencha o campo **facebook_pixel_id** com seu ID (ex: `123456789012345`)
3. O Pixel será inserido automaticamente com PageView tracking

### Scripts Customizados

Para outros scripts (GTM, Hotjar, etc.), use o campo **scripts_head**:
- Cole o script completo incluindo as tags `<script></script>`
- Será inserido no `<head>` de todas as páginas protegidas

**Exemplo:**
```html
<script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXX"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'G-XXXXXXX');
</script>
```

---

## Detecção de VPN/Proxy/Datacenter

O sistema detecta automaticamente:

- **VPNs Comerciais**: NordVPN, ExpressVPN, Surfshark, etc.
- **Proxies**: Proxies públicos e residenciais
- **Datacenters**: AWS, Google Cloud, Azure, DigitalOcean, Vultr, Linode, OVH, Hetzner, Contabo
- **Hosting Providers**: Qualquer IP de servidor/hosting
- **Bots**: Crawlers, scrapers, ferramentas de automação
- **Facebook Crawlers**: Facebot, facebookexternalhit

A detecção usa:
1. Base de ranges de IP de datacenters conhecidos
2. Consulta à API ip-api.com para verificar ISP
3. Análise de User Agent para bots

---

## Gerenciamento de IPs

### Whitelist

IPs na whitelist **nunca são bloqueados**, mesmo que falhem em outros filtros.

- Adicione seu IP para testes
- Adicione IPs de parceiros autorizados

### Blacklist

IPs na blacklist são **sempre bloqueados**.

- Suporta IPs individuais: `192.168.1.100`
- Suporta ranges CIDR: `192.168.1.0/24` (bloqueia 256 IPs)

Acesse via painel: **IPs** no menu de navegação.

---

## Exemplo de URL Ideal (Permitida)

Uma URL que passará em todos os filtros de proteção:

```
https://seusite.com/?pclid=MTczNTMyMTYwMC4xMjM0NTY3ODkwYWJjZGVm&utm_source=facebook&utm_medium=cpc&utm_campaign=campanha_natal&fbclid=IwZXh0bgNhZW0CMTEAAR1234...
```

**Parâmetros importantes:**

| Parâmetro | Descrição | Obrigatório* |
|-----------|-----------|--------------|
| `pclid` | Token único gerado no painel | Sim (se filtro ativo) |
| `utm_source` | Origem do tráfego (facebook, instagram) | Sim (se filtro ativo) |
| `utm_medium` | Tipo de mídia (cpc, cpm, social) | Sim (se filtro ativo) |
| `utm_campaign` | Nome da campanha | Sim (se filtro ativo) |
| `fbclid` | ID do clique do Facebook (gerado automaticamente) | Não |

*Depende das configurações ativas no painel

**Requisitos adicionais para acesso permitido:**
- Dispositivo: Mobile (se filtro de dispositivo ativo)
- Referer: Vindo do Facebook/Instagram
- IP: Não ser VPN/Proxy/Datacenter
- IP: Não estar na blacklist
- User Agent: Não ser bot/crawler

---

## Gerando URLs para Anúncios

### Com Token PCLID

Se você ativou o filtro de PCLID, gere URLs protegidas:

```php
<?php
require_once __DIR__ . '/protetor/protetor.php';

// Gerar URL com token
$url = protetor_gerar_url('https://seusite.com/', [
    'utm_source' => 'facebook',
    'utm_medium' => 'cpc',
    'utm_campaign' => 'campanha1'
]);

echo $url;
// https://seusite.com/?pclid=TOKEN&utm_source=facebook&utm_medium=cpc&utm_campaign=campanha1
```

### Via Painel Admin

Acesse **Tokens** no painel admin para gerar múltiplos tokens de uma vez.

---

## Estrutura de Tabelas

As tabelas são criadas com o prefixo configurado:

| Tabela | Descrição |
|--------|-----------|
| `protetor_config` | Configurações do sistema |
| `protetor_visitantes` | Visitantes que passaram nos filtros |
| `protetor_bloqueios` | Log de acessos bloqueados |
| `protetor_ip_whitelist` | IPs sempre permitidos |
| `protetor_ip_blacklist` | IPs sempre bloqueados |
| `protetor_tokens` | Tokens PCLID gerados |
| `protetor_estatisticas` | Estatísticas diárias |

---

## Integração com Projeto Externo

### Passo a Passo

1. **Copie a pasta `protetor`** para a raiz do outro projeto

2. **Configure o banco de dados** via instalador (`/protetor/install.php`)

3. **Inclua nas páginas protegidas**:

```php
<?php
// Ajuste o caminho conforme a estrutura do projeto
require_once __DIR__ . '/protetor/protetor.php';
protetor_verificar();
?>
```

4. **Adicione no HTML**:

```php
<head>
    <?= protetor_head() ?>
</head>
<body>
    <!-- conteúdo -->
    <?= protetor_body() ?>
</body>
```

### Exemplo: Protegendo uma Landing Page

```php
<?php
// landing.php
require_once __DIR__ . '/protetor/protetor.php';

// Verificar acesso (bloqueia se não vier do anúncio)
protetor_verificar();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Oferta Especial</title>
    <?= protetor_head() ?>
</head>
<body>
    <h1>Sua Landing Page</h1>
    <!-- conteúdo -->

    <?= protetor_body() ?>
</body>
</html>
```

### Exemplo: Checkout Protegido

```php
<?php
// checkout.php
require_once __DIR__ . '/protetor/protetor.php';

// Usa cache pois usuário já foi validado na landing
protetor_verificar_com_cache();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Checkout</title>
    <?= protetor_head() ?>
</head>
<body>
    <form><!-- checkout form --></form>

    <?= protetor_body() ?>
</body>
</html>
```

---

## Funções Disponíveis

| Função | Descrição |
|--------|-----------|
| `protetor_verificar()` | Verifica todos os filtros e bloqueia se não passar |
| `protetor_verificar_com_cache()` | Verifica usando cache da sessão |
| `protetor_ja_validado()` | Retorna true se já passou pela validação |
| `protetor_head()` | Retorna HTML para incluir no `<head>` |
| `protetor_body()` | Retorna HTML/JS para incluir antes de `</body>` |
| `protetor_gerar_url($url, $utms)` | Gera URL protegida com WPCLID |
| `protetor_get_config($chave)` | Obtém uma configuração |

---

## Arquivos Principais

| Arquivo | Descrição |
|---------|-----------|
| `protetor.php` | Arquivo principal - inclua este nas páginas |
| `detector.php` | Detecção de VPN/Proxy/Datacenter/Bots |
| `anti_clone.php` | Proteções JavaScript anti-inspeção |
| `filtro_device.php` | Detecção de dispositivo (mobile/desktop) |
| `filtro_referer.php` | Verificação de referer |
| `pclid.php` | Geração e validação de tokens |
| `install.php` | Instalador automático |
| `db_config.php` | Configurações do banco (gerado na instalação) |

---

## Logs e Debug

### Log de Bloqueios

Arquivo: `protetor_bloqueios.log` na raiz do projeto

Formato:
```
2024-01-15 14:30:45 | BLOQUEADO | desktop_bloqueado | IP: 192.168.1.100
```

### Verificar no Banco

```sql
-- Últimos bloqueios
SELECT * FROM protetor_bloqueios ORDER BY criado_em DESC LIMIT 20;

-- Visitantes válidos
SELECT * FROM protetor_visitantes ORDER BY validado_em DESC LIMIT 20;

-- IPs na whitelist
SELECT * FROM protetor_ip_whitelist;

-- IPs na blacklist
SELECT * FROM protetor_ip_blacklist;
```

---

## Dicas de Segurança

1. **Use credenciais fortes** na instalação do painel
2. **Adicione seu IP na whitelist** para não ser bloqueado durante testes
3. **Use HTTPS** em produção
4. **Não exponha a pasta admin** publicamente (use `.htaccess` se necessário)
5. **Monitore os logs** regularmente para identificar tentativas de acesso
6. **Atualize as listas de bots e ISPs** periodicamente nas configurações

---

## Suporte

Para problemas ou sugestões, verifique:
- Os logs em `protetor_bloqueios.log`
- A tabela `protetor_bloqueios` no banco
- As configurações no painel admin
- A whitelist caso esteja sendo bloqueado durante testes

---

**Versão**: 1.1
**Compatibilidade**: PHP 7.2+, MySQL 5.7+
