<?php
/**
 * TESTE: Ler JSON e enviar para UTMify
 */

header('Content-Type: text/plain; charset=utf-8');
date_default_timezone_set('America/Sao_Paulo');

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/utmify.php';

// Transação para testar (uma das 3 que não funcionaram)
$txId = $_GET['id'] ?? '1c5be10a-c31c-4c82-b770-46ef9c8ab582';

echo "=== TESTE DE ENVIO PARA UTMIFY ===\n\n";

// 1. Verifica constante UTM_STORAGE_DIR
echo "1. UTM_STORAGE_DIR: ";
if (defined('UTM_STORAGE_DIR')) {
    echo UTM_STORAGE_DIR . "\n";
} else {
    echo "❌ NÃO DEFINIDO!\n";
    exit;
}

// 2. Tenta ler o arquivo JSON
$jsonFile = UTM_STORAGE_DIR . $txId . '.json';
echo "\n2. Arquivo: $jsonFile\n";
echo "   Existe: " . (file_exists($jsonFile) ? "✅ Sim" : "❌ Não") . "\n";

if (!file_exists($jsonFile)) {
    echo "\n❌ Arquivo não encontrado!\n";
    echo "\nListando arquivos em " . UTM_STORAGE_DIR . ":\n";
    $files = glob(UTM_STORAGE_DIR . '*.json');
    foreach (array_slice($files, 0, 5) as $f) {
        echo "   - " . basename($f) . "\n";
    }
    exit;
}

// 3. Lê o conteúdo
$content = file_get_contents($jsonFile);
$savedData = json_decode($content, true);

echo "\n3. Conteúdo do JSON:\n";
echo json_encode($savedData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";

// 4. Prepara dados como o webhook faz
echo "\n4. Preparando dados para UTMify...\n";

$customer = [
    'name' => $savedData['customer']['name'] ?? $savedData['nome'] ?? '',
    'email' => $savedData['customer']['email'] ?? $savedData['email'] ?? '',
    'phone' => $savedData['customer']['phone'] ?? $savedData['telefone'] ?? $savedData['celular'] ?? '',
    'document' => $savedData['customer']['document'] ?? $savedData['cpf'] ?? '',
    'ip' => $savedData['customer_ip'] ?? '127.0.0.1'
];

$product = [
    'id' => $savedData['produto_id'] ?? 'premios-001',
    'name' => $savedData['produto'] ?? 'Prêmios do Carlinhos',
    'quantity' => $savedData['cotas'] ?? 1
];

$utms = [
    'sck' => $savedData['sck'] ?? '',
    'src' => $savedData['src'] ?? '',
    'utm_source' => $savedData['utm_source'] ?? '',
    'utm_medium' => $savedData['utm_medium'] ?? '',
    'utm_campaign' => $savedData['utm_campaign'] ?? '',
    'utm_content' => $savedData['utm_content'] ?? '',
    'utm_term' => $savedData['utm_term'] ?? ''
];

$amountCents = $savedData['valor_centavos'] ?? 0;

echo "   Customer: " . json_encode($customer, JSON_UNESCAPED_UNICODE) . "\n";
echo "   Product: " . json_encode($product, JSON_UNESCAPED_UNICODE) . "\n";
echo "   UTMs: " . json_encode($utms, JSON_UNESCAPED_UNICODE) . "\n";
echo "   Amount: $amountCents centavos\n";

// 5. Envia para UTMify
echo "\n5. Enviando para UTMify...\n";

$utmify = new Utmify();

// Primeiro waiting_payment
echo "\n   Enviando waiting_payment...\n";
$result1 = $utmify->sendPending($txId, $amountCents, $customer, $product, $utms);
echo "   Resultado: " . json_encode($result1, JSON_PRETTY_PRINT) . "\n";

sleep(1);

// Depois paid
echo "\n   Enviando paid...\n";
$result2 = $utmify->sendPaid($txId, $amountCents, $customer, $product, $utms);
echo "   Resultado: " . json_encode($result2, JSON_PRETTY_PRINT) . "\n";

echo "\n=== TESTE FINALIZADO ===\n";
echo "\nVerifique no painel do UTMify se a venda apareceu!\n";