<?php
/**
 * ============================================
 * CONFIGURAÇÃO CENTRAL - TRACKING QUALIDADE MÁXIMA
 * ============================================
 * Versão: 3.0 - Suporte completo ao gateways.json
 */

date_default_timezone_set('America/Sao_Paulo');

// ========== FACEBOOK CAPI ==========
define('FB_PIXEL_ID', '2357252418054828');
define('FB_ACCESS_TOKEN', 'EAAMchqNcUmMBQiBm6tuKZBZAkDYffLazN5u3wApky1afxti4SXtLDs5eW6vN6Pe6Jvss0KZAGvXiZCHeSc4Q2ZAqGm8aBwNbMVn7YWbcYuOOAHjvwe95DnKMq8lWawz2WwuOJcQ5Rrs259LdD6EZCZBKpNcyZBIDgqZCtT2R8Cd8ggpmdryqZBnFTGVpxSw2GmjQZDZD');
define('FB_API_VERSION', 'v18.0');
define('FB_TEST_EVENT_CODE', ''); // Deixe vazio em produção

// ========== UTMIFY ==========
define('UTMIFY_TOKEN', ''); // Configure seu token aqui

// ========== PRODUTO PADRÃO ==========
define('PRODUTO_NOME', 'ebook-vidanova01');
define('PRODUTO_ID', 'ebook-001');
define('VALOR_PADRAO_CENTAVOS', 5990);
define('VALOR_PADRAO_REAIS', 59.90);

// ========== URLs ==========
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
define('SITE_URL', $protocol . '://' . $host);
define('WEBHOOK_URL', SITE_URL . '/api/webhook.php');
define('UTM_STORAGE_DIR', __DIR__ . '/utm_data/');

// ========== ARQUIVO DE GATEWAYS ==========
define('GATEWAYS_CONFIG_FILE', __DIR__ . '/gateways.json');

// ============================================
// CARREGA CONFIGURAÇÃO DOS GATEWAYS
// ============================================
function loadGatewaysConfig() {
    static $config = null;
    
    if ($config !== null) {
        return $config;
    }
    
    // Tenta carregar do arquivo gateways.json
    if (file_exists(GATEWAYS_CONFIG_FILE)) {
        $json = file_get_contents(GATEWAYS_CONFIG_FILE);
        $loaded = json_decode($json, true);
        
        if ($loaded && isset($loaded['gateways'])) {
            $config = $loaded;
            return $config;
        }
    }
    
    // Fallback para configuração padrão
    $config = getDefaultGatewaysConfig();
    return $config;
}

/**
 * Configuração padrão dos gateways (fallback)
 */
function getDefaultGatewaysConfig() {
    return [
        'gateway_ativo' => 'allowpay',
        'gateways' => [
            'allowpay' => [
                'enabled' => true,
                'name' => 'AllowPay',
                'status_field' => 'status',
                'txid_field' => 'id',
                'valor_em_reais' => false
            ],
            'umbrella' => [
                'enabled' => true,
                'name' => 'Umbrella',
                'status_field' => 'data.data[0].status',
                'txid_field' => 'data.id',
                'valor_em_reais' => false
            ],
            'techbynet' => [
                'enabled' => true,
                'name' => 'TechByNet',
                'status_field' => 'data.data.status',
                'txid_field' => 'data.id',
                'valor_em_reais' => false
            ],
            'genesys' => [
                'enabled' => true,
                'name' => 'Genesys Finance',
                'status_field' => 'status',
                'txid_field' => 'id',
                'valor_em_reais' => true
            ]
        ],
        'status_map' => getDefaultStatusMap()
    ];
}

/**
 * Mapeamento padrão de status
 */
function getDefaultStatusMap() {
    return [
        // Pagos
        'PAID' => 'paid',
        'paid' => 'paid',
        'AUTHORIZED' => 'paid',
        'authorized' => 'paid',
        'CONCLUIDA' => 'paid',
        'APPROVED' => 'paid',
        'approved' => 'paid',
        'COMPLETED' => 'paid',
        'completed' => 'paid',
        'CONFIRMED' => 'paid',
        'confirmed' => 'paid',
        
        // Pendentes
        'PENDING' => 'pending',
        'pending' => 'pending',
        'WAITING' => 'pending',
        'waiting' => 'pending',
        'WAITING_PAYMENT' => 'pending',
        'waiting_payment' => 'pending',
        'PROCESSING' => 'pending',
        'processing' => 'pending',
        'ATIVA' => 'pending',
        'IN_PROTEST' => 'pending',
        'IN_DISPUTE' => 'pending',
        
        // Expirados
        'EXPIRED' => 'expired',
        'expired' => 'expired',
        
        // Cancelados
        'CANCELLED' => 'cancelled',
        'cancelled' => 'cancelled',
        'CANCELED' => 'cancelled',
        'canceled' => 'cancelled',
        'REFUSED' => 'cancelled',
        'refused' => 'cancelled',
        'FAILED' => 'cancelled',
        'failed' => 'cancelled',
        
        // Reembolsados
        'CHARGEDBACK' => 'refunded',
        'chargedback' => 'refunded',
        'CHARGEBACK' => 'refunded',
        'REFUNDED' => 'refunded',
        'refunded' => 'refunded'
    ];
}

/**
 * Retorna o nome do gateway ativo
 */
function getGatewayName() {
    $config = loadGatewaysConfig();
    return $config['gateway_ativo'] ?? 'allowpay';
}

/**
 * Retorna a configuração de um gateway específico
 */
function getGatewayConfig($gatewayName = null) {
    $config = loadGatewaysConfig();
    $name = $gatewayName ?? getGatewayName();
    return $config['gateways'][$name] ?? null;
}

/**
 * Retorna todos os gateways configurados
 */
function getAllGateways() {
    $config = loadGatewaysConfig();
    return $config['gateways'] ?? [];
}

/**
 * Retorna o mapeamento de status
 */
function getStatusMap() {
    $config = loadGatewaysConfig();
    return $config['status_map'] ?? getDefaultStatusMap();
}

/**
 * Mapeia status da API para status interno
 */
function mapStatus($apiStatus) {
    if (empty($apiStatus)) return 'unknown';
    
    $statusMap = getStatusMap();
    
    // Tenta exato
    if (isset($statusMap[$apiStatus])) {
        return $statusMap[$apiStatus];
    }
    
    // Tenta uppercase
    $upper = strtoupper(trim($apiStatus));
    if (isset($statusMap[$upper])) {
        return $statusMap[$upper];
    }
    
    // Tenta lowercase
    $lower = strtolower(trim($apiStatus));
    if (isset($statusMap[$lower])) {
        return $statusMap[$lower];
    }
    
    return 'unknown';
}

/**
 * Verifica se o status indica pagamento confirmado
 */
function isPaidStatus($status) {
    if (empty($status)) return false;
    
    // Lista completa de status pagos
    $paidStatuses = [
        'paid', 'PAID',
        'approved', 'APPROVED',
        'authorized', 'AUTHORIZED',
        'completed', 'COMPLETED',
        'confirmed', 'CONFIRMED',
        'CONCLUIDA'
    ];
    
    // Verifica direto
    if (in_array($status, $paidStatuses)) {
        return true;
    }
    
    // Verifica case insensitive
    if (in_array(strtoupper(trim($status)), array_map('strtoupper', $paidStatuses))) {
        return true;
    }
    
    // Verifica via mapeamento
    return mapStatus($status) === 'paid';
}

// ============================================
// FUNÇÕES AUXILIARES
// ============================================

/**
 * Headers CORS
 */
function setCorsHeaders() {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
    header('Content-Type: application/json; charset=utf-8');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}

/**
 * Log de checkout/API
 */
function logCheckout($file, $message, $data = []) {
    $logDir = __DIR__ . '/logs';
    if (!is_dir($logDir)) {
        @mkdir($logDir, 0755, true);
    }
    
    $logFile = $logDir . '/' . $file;
    $timestamp = date('Y-m-d H:i:s');
    
    $logLine = "[$timestamp] $message";
    if (!empty($data)) {
        $logLine .= ' | ' . json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
    $logLine .= "\n";
    
    @file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
}

/**
 * Alias para logCheckout
 */
function logApi($file, $message, $data = []) {
    logCheckout($file, $message, $data);
}

// ============================================
// INICIALIZAÇÃO
// ============================================

// Cria diretórios necessários
$directories = [
    UTM_STORAGE_DIR,
    __DIR__ . '/logs',
    __DIR__ . '/cache',
    __DIR__ . '/comprovantes',
    __DIR__ . '/sessions'
];

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        @mkdir($dir, 0755, true);
    }
}