<?php
/**
 * ============================================
 * CONFIGURAÇÃO CENTRAL - MULTI-GATEWAY
 * ============================================
 * Versão 2.1 - isPaidStatus corrigido
 */

// ========== FACEBOOK ==========
define('FB_PIXEL_ID', '2357252418054828');
define('FB_ACCESS_TOKEN', 'EAAMchqNcUmMBQiBm6tuKZBZAkDYffLazN5u3wApky1afxti4SXtLDs5eW6vN6Pe6Jvss0KZAGvXiZCHeSc4Q2ZAqGm8aBwNbMVn7YWbcYuOOAHjvwe95DnKMq8lWawz2WwuOJcQ5Rrs259LdD6EZCZBKpNcyZBIDgqZCtT2R8Cd8ggpmdryqZBnFTGVpxSw2GmjQZDZD');
define('FB_API_VERSION', 'v18.0');
define('FB_TEST_EVENT_CODE', ''); // Deixe vazio em produção

// Configurações do produto
define('PRODUTO_NOME', 'Ebook01');
define('PRODUTO_ID', 'ebook01veeg-001');
define('SITE_URL', 'https://brvaloresareceber.com');

// URLs
define('WEBHOOK_URL', 'https://brvaloresareceber.com/seguro/consulta/tarifa/api/webhook.php');
define('UTM_STORAGE_DIR', __DIR__ . '/utm_data/');

// Arquivo de configuração dos gateways
define('GATEWAYS_CONFIG_FILE', __DIR__ . '/gateways.json');

// ============================================
// CARREGA CONFIGURAÇÃO DOS GATEWAYS
// ============================================

function loadGatewaysConfig() {
    static $config = null;
    
    if ($config !== null) {
        return $config;
    }
    
    if (file_exists(GATEWAYS_CONFIG_FILE)) {
        $json = file_get_contents(GATEWAYS_CONFIG_FILE);
        $config = json_decode($json, true);
        
        if ($config) {
            return $config;
        }
    }
    
    // Fallback para configuração padrão
    $config = [
        'gateway_ativo' => 'allowpay',
        'gateways' => [],
        'status_map' => [
            'PAID' => 'paid',
            'paid' => 'paid',
            'AUTHORIZED' => 'paid',
            'APPROVED' => 'paid',
            'COMPLETED' => 'paid',
            'CONFIRMED' => 'paid',
            'CONCLUIDA' => 'paid',
            'PENDING' => 'pending',
            'WAITING' => 'pending',
            'WAITING_PAYMENT' => 'pending',
            'waiting_payment' => 'pending',
            'PROCESSING' => 'pending',
            'EXPIRED' => 'expired',
            'CANCELLED' => 'cancelled',
            'CANCELED' => 'cancelled'
        ]
    ];
    
    return $config;
}

function getGatewayName() {
    $config = loadGatewaysConfig();
    return $config['gateway_ativo'] ?? 'allowpay';
}

function getGatewayConfig() {
    $config = loadGatewaysConfig();
    $gatewayName = $config['gateway_ativo'] ?? 'allowpay';
    return $config['gateways'][$gatewayName] ?? null;
}

function getAllGateways() {
    $config = loadGatewaysConfig();
    return $config['gateways'] ?? [];
}

function getStatusMap() {
    $config = loadGatewaysConfig();
    return $config['status_map'] ?? [];
}

function mapStatus($apiStatus) {
    if (empty($apiStatus)) return 'unknown';
    
    $statusMap = getStatusMap();
    
    // Tenta encontrar exatamente como veio
    if (isset($statusMap[$apiStatus])) {
        return $statusMap[$apiStatus];
    }
    
    // Tenta em maiúsculo
    $statusUpper = strtoupper($apiStatus);
    if (isset($statusMap[$statusUpper])) {
        return $statusMap[$statusUpper];
    }
    
    // Tenta em minúsculo
    $statusLower = strtolower($apiStatus);
    if (isset($statusMap[$statusLower])) {
        return $statusMap[$statusLower];
    }
    
    return 'unknown';
}

/**
 * Verifica se o status indica pagamento confirmado
 * CORREÇÃO: Lista abrangente e comparação case-insensitive
 */
function isPaidStatus($status) {
    if (empty($status)) {
        return false;
    }
    
    // Normaliza para minúsculo
    $statusLower = strtolower(trim($status));
    
    // Lista de status que indicam pagamento confirmado
    $paidStatuses = [
        'paid',
        'approved',
        'authorized',
        'completed',
        'confirmed',
        'success',
        'successful',
        'settled',
        'captured',
        'done',
        'finished',
        'accepted',
        'processed',
        'received',
        // Português
        'pago',
        'aprovado',
        'autorizado',
        'concluido',
        'concluída',
        'confirmado',
        'sucesso',
        'finalizado',
        'recebido'
    ];
    
    if (in_array($statusLower, $paidStatuses)) {
        return true;
    }
    
    // Também verifica via status_map
    $mapped = mapStatus($status);
    if ($mapped === 'paid') {
        return true;
    }
    
    return false;
}

/**
 * Extrai valor de resposta usando path como "data.data[0].status"
 */
function extractByPath($data, $path) {
    if (!$path || !$data) return null;
    
    $parts = preg_split('/\./', $path);
    $current = $data;
    
    foreach ($parts as $part) {
        if (preg_match('/^(.+)\[(\d+)\]$/', $part, $matches)) {
            $key = $matches[1];
            $index = (int)$matches[2];
            
            if (!isset($current[$key]) || !is_array($current[$key])) {
                return null;
            }
            $current = $current[$key][$index] ?? null;
        } else {
            if (!isset($current[$part])) {
                return null;
            }
            $current = $current[$part];
        }
        
        if ($current === null) return null;
    }
    
    return $current;
}

// ============================================
// FUNÇÕES AUXILIARES
// ============================================

function setCorsHeaders() {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
    header('Content-Type: application/json; charset=utf-8');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit;
    }
}

function logCheckout($file, $message, $data = []) {
    $logDir = __DIR__ . '/logs';
    if (!is_dir($logDir)) {
        mkdir($logDir, 0755, true);
    }
    
    $logFile = $logDir . '/' . $file;
    $timestamp = date('Y-m-d H:i:s');
    
    $logLine = "[$timestamp] $message";
    if (!empty($data)) {
        $logLine .= ' | ' . json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
    $logLine .= "\n";
    
    file_put_contents($logFile, $logLine, FILE_APPEND | LOCK_EX);
}

function generateTxRef($prefix = 'TX') {
    return $prefix . time() . rand(1000, 9999);
}

function toCents($value) {
    return intval(floatval($value) * 100);
}

function toReais($cents) {
    return number_format($cents / 100, 2, ',', '.');
}

// Cria diretório de UTM se não existir
if (!is_dir(UTM_STORAGE_DIR)) {
    @mkdir(UTM_STORAGE_DIR, 0755, true);
}